/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.dagger;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.dagger.application.ApplicationComponent;
import com.contentsquare.android.internal.dagger.application.ApplicationModule;
import com.contentsquare.android.internal.dagger.application.DaggerApplicationComponent;
import com.contentsquare.android.internal.dagger.session.DaggerSessionComponent;
import com.contentsquare.android.internal.dagger.session.SessionComponent;
import com.contentsquare.android.internal.dagger.session.SessionModule;
import com.contentsquare.android.internal.dagger.session.TrackingModule;
import com.contentsquare.android.internal.logging.Logger;

public class SingletonProvider {
    private static ApplicationComponent sAppComponent;
    private static SessionComponent sSessionComponent;

    @VisibleForTesting
    SingletonProvider() {
        throw new UnsupportedOperationException("This class cannot be instantiated.");
    }

    public static boolean init(@NonNull Context context, @NonNull String projectId) {
        if (sAppComponent == null && sSessionComponent == null) {
            Logger.init();
            Application application = (Application)context.getApplicationContext();
            if (sAppComponent == null) {
                sAppComponent = DaggerApplicationComponent.builder().applicationModule(new ApplicationModule(application)).build();
            }
            if (sSessionComponent == null) {
                sSessionComponent = DaggerSessionComponent.builder().applicationComponent(SingletonProvider.getAppComponent()).sessionModule(new SessionModule(projectId)).trackingModule(new TrackingModule()).build();
            }
            return true;
        }
        return false;
    }

    @NonNull
    public static SessionComponent getSessionComponent() {
        return sSessionComponent;
    }

    public static void setSessionComponent(SessionComponent sessionComponent) {
        sSessionComponent = sessionComponent;
    }

    @NonNull
    public static ApplicationComponent getAppComponent() {
        return sAppComponent;
    }

    public static void setAppComponent(ApplicationComponent appComponent) {
        sAppComponent = appComponent;
    }

    public static void reset() {
        sAppComponent = null;
        sSessionComponent = null;
    }
}

