/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.dagger.application;

import android.app.Application;
import android.support.annotation.NonNull;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.factories.TasksFactory;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.DateTimeUtil;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.util.ViewUtil;
import com.contentsquare.android.internal.validator.InSampleIntervalValidator;
import dagger.Module;
import dagger.Provides;
import javax.inject.Singleton;

@Module
public class ApplicationModule {
    private final Application mApplication;

    public ApplicationModule(@NonNull Application application) {
        this.mApplication = application;
    }

    @Provides
    @Singleton
    @NonNull
    public Application provideApplication() {
        return this.mApplication;
    }

    @Provides
    @Singleton
    @NonNull
    public PrefsHelper providePreferencesHelper() {
        return new PrefsHelper(this.mApplication.getBaseContext());
    }

    @Provides
    @Singleton
    @NonNull
    public ConfigurationCompositor provideCompositor(@NonNull PrefsHelper prefsHelper) {
        return new ConfigurationCompositor(new InSampleIntervalValidator(prefsHelper, new Logger("InSampleIntervalValidator")));
    }

    @Provides
    @Singleton
    @NonNull
    public DeviceInfo provideDeviceInfo() {
        return new DeviceInfo(this.mApplication);
    }

    @Provides
    @Singleton
    @NonNull
    public AssetManager provideAssetManager() {
        return new AssetManager(this.mApplication.getBaseContext());
    }

    @Provides
    @Singleton
    @NonNull
    public TasksFactory providesTasksFactoryInstance(@NonNull UriBuilder uriBuilder, @NonNull Application application) {
        return new TasksFactory(uriBuilder, application.getBaseContext());
    }

    @Provides
    @Singleton
    @NonNull
    public UriBuilder provideUriBuilder(DeviceInfo deviceInfo) {
        return new UriBuilder(deviceInfo);
    }

    @Provides
    @Singleton
    @NonNull
    public ViewUtil provideViewUtil() {
        return new ViewUtil();
    }

    @Provides
    @Singleton
    @NonNull
    public DateTimeUtil provideDateTimeUtil() {
        return new DateTimeUtil();
    }
}

