/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.dagger.application;

import android.app.Application;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.dagger.application.ApplicationComponent;
import com.contentsquare.android.internal.dagger.application.ApplicationModule;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideApplicationFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideAssetManagerFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideCompositorFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideDateTimeUtilFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideDeviceInfoFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvidePreferencesHelperFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideUriBuilderFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvideViewUtilFactory;
import com.contentsquare.android.internal.dagger.application.ApplicationModule_ProvidesTasksFactoryInstanceFactory;
import com.contentsquare.android.internal.factories.TasksFactory;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.ui.glasspane.GlassPaneLayout;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.ConfigurationHelper;
import com.contentsquare.android.internal.util.ConfigurationHelper_MembersInjector;
import com.contentsquare.android.internal.util.DateTimeUtil;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.util.ViewUtil;
import dagger.MembersInjector;
import dagger.internal.DoubleCheck;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DaggerApplicationComponent
implements ApplicationComponent {
    private Provider<Application> provideApplicationProvider;
    private Provider<DeviceInfo> provideDeviceInfoProvider;
    private Provider<PrefsHelper> providePreferencesHelperProvider;
    private Provider<ConfigurationCompositor> provideCompositorProvider;
    private Provider<AssetManager> provideAssetManagerProvider;
    private Provider<UriBuilder> provideUriBuilderProvider;
    private Provider<TasksFactory> providesTasksFactoryInstanceProvider;
    private Provider<ViewUtil> provideViewUtilProvider;
    private Provider<DateTimeUtil> provideDateTimeUtilProvider;
    private MembersInjector<ConfigurationHelper> configurationHelperMembersInjector;

    private DaggerApplicationComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideApplicationProvider = DoubleCheck.provider(ApplicationModule_ProvideApplicationFactory.create(builder.applicationModule));
        this.provideDeviceInfoProvider = DoubleCheck.provider(ApplicationModule_ProvideDeviceInfoFactory.create(builder.applicationModule));
        this.providePreferencesHelperProvider = DoubleCheck.provider(ApplicationModule_ProvidePreferencesHelperFactory.create(builder.applicationModule));
        this.provideCompositorProvider = DoubleCheck.provider(ApplicationModule_ProvideCompositorFactory.create(builder.applicationModule, this.providePreferencesHelperProvider));
        this.provideAssetManagerProvider = DoubleCheck.provider(ApplicationModule_ProvideAssetManagerFactory.create(builder.applicationModule));
        this.provideUriBuilderProvider = DoubleCheck.provider(ApplicationModule_ProvideUriBuilderFactory.create(builder.applicationModule, this.provideDeviceInfoProvider));
        this.providesTasksFactoryInstanceProvider = DoubleCheck.provider(ApplicationModule_ProvidesTasksFactoryInstanceFactory.create(builder.applicationModule, this.provideUriBuilderProvider, this.provideApplicationProvider));
        this.provideViewUtilProvider = DoubleCheck.provider(ApplicationModule_ProvideViewUtilFactory.create(builder.applicationModule));
        this.provideDateTimeUtilProvider = DoubleCheck.provider(ApplicationModule_ProvideDateTimeUtilFactory.create(builder.applicationModule));
        this.configurationHelperMembersInjector = ConfigurationHelper_MembersInjector.create(this.providePreferencesHelperProvider, this.provideCompositorProvider);
    }

    @Override
    public Application getApplication() {
        return (Application)this.provideApplicationProvider.get();
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return (DeviceInfo)this.provideDeviceInfoProvider.get();
    }

    @Override
    public PrefsHelper getPrefsHelper() {
        return (PrefsHelper)this.providePreferencesHelperProvider.get();
    }

    @Override
    public ConfigurationCompositor getConfigurationCompositor() {
        return (ConfigurationCompositor)this.provideCompositorProvider.get();
    }

    @Override
    public AssetManager getAssetManager() {
        return (AssetManager)this.provideAssetManagerProvider.get();
    }

    @Override
    public TasksFactory getTasksFactory() {
        return (TasksFactory)this.providesTasksFactoryInstanceProvider.get();
    }

    @Override
    public UriBuilder getUriBuilder() {
        return (UriBuilder)this.provideUriBuilderProvider.get();
    }

    @Override
    public ViewUtil getViewUtil() {
        return (ViewUtil)this.provideViewUtilProvider.get();
    }

    @Override
    public DateTimeUtil getDateTimeUtil() {
        return (DateTimeUtil)this.provideDateTimeUtilProvider.get();
    }

    @Override
    public void inject(ConfigurationHelper configurationHelper) {
        this.configurationHelperMembersInjector.injectMembers((Object)configurationHelper);
    }

    @Override
    public void inject(GlassPaneLayout glassPaneLayout) {
        MembersInjectors.noOp().injectMembers((Object)glassPaneLayout);
    }

    public static final class Builder {
        private ApplicationModule applicationModule;

        private Builder() {
        }

        public ApplicationComponent build() {
            if (this.applicationModule == null) {
                throw new IllegalStateException(ApplicationModule.class.getCanonicalName() + " must be set");
            }
            return new DaggerApplicationComponent(this);
        }

        public Builder applicationModule(ApplicationModule applicationModule) {
            this.applicationModule = (ApplicationModule)Preconditions.checkNotNull((Object)applicationModule);
            return this;
        }
    }
}

