/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.dagger.session;

import android.app.Application;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.async.ThreadExecutor;
import com.contentsquare.android.internal.dagger.application.ApplicationComponent;
import com.contentsquare.android.internal.dagger.session.AsyncModule;
import com.contentsquare.android.internal.dagger.session.AsyncModule_ProvideThreadPoolFactory;
import com.contentsquare.android.internal.dagger.session.HttpModule;
import com.contentsquare.android.internal.dagger.session.HttpModule_ProvideConnectorFactory;
import com.contentsquare.android.internal.dagger.session.SessionComponent;
import com.contentsquare.android.internal.dagger.session.SessionModule;
import com.contentsquare.android.internal.dagger.session.SessionModule_ProvidePathGeneratorFactory;
import com.contentsquare.android.internal.dagger.session.SessionModule_ProvideScreenRecorderFactory;
import com.contentsquare.android.internal.dagger.session.SessionModule_ProvideSessionFactory;
import com.contentsquare.android.internal.dagger.session.SessionUtilitiesModule;
import com.contentsquare.android.internal.dagger.session.SessionUtilitiesModule_ProvidePathDescriptorFactory;
import com.contentsquare.android.internal.dagger.session.TrackingModule;
import com.contentsquare.android.internal.dagger.session.TrackingModule_ProvideEventsFactoryFactory;
import com.contentsquare.android.internal.dagger.session.TrackingModule_ProvideGlassFactory;
import com.contentsquare.android.internal.dagger.session.TrackingModule_ProvideProcessorFactory;
import com.contentsquare.android.internal.dagger.session.TrackingModule_ProvideProxyFactory;
import com.contentsquare.android.internal.events.processing.EventsProcessor;
import com.contentsquare.android.internal.factories.TasksFactory;
import com.contentsquare.android.internal.listeners.CsActivityCallbacks;
import com.contentsquare.android.internal.listeners.CsComponentChange;
import com.contentsquare.android.internal.listeners.CsComponentChange_MembersInjector;
import com.contentsquare.android.internal.model.EventsFactory;
import com.contentsquare.android.internal.model.JsonProxy;
import com.contentsquare.android.internal.network.NetworkTransaction;
import com.contentsquare.android.internal.network.NetworkTransaction_MembersInjector;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.screengraph.PathGenerator;
import com.contentsquare.android.internal.screengraph.TreeTraverser;
import com.contentsquare.android.internal.screengraph.TreeTraverser_MembersInjector;
import com.contentsquare.android.internal.screenmonitoring.IScreenMonitoringService;
import com.contentsquare.android.internal.screenmonitoring.ScreenMonitoringModule;
import com.contentsquare.android.internal.screenmonitoring.ScreenMonitoringModule_ProvideScreenMonitoringServiceFactory;
import com.contentsquare.android.internal.ui.glasspane.IGlassPane;
import com.contentsquare.android.internal.ui.processor.descriptors.PathDescriptor;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.HttpConnection;
import com.contentsquare.android.internal.util.ScreenRecorder;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.util.ViewUtil;
import dagger.MembersInjector;
import dagger.internal.DoubleCheck;
import dagger.internal.Factory;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DaggerSessionComponent
implements SessionComponent {
    private Provider<Application> getApplicationProvider;
    private Provider<PrefsHelper> getPrefsHelperProvider;
    private Provider<IGlassPane> provideGlassProvider;
    private Provider<EventsProcessor> provideProcessorProvider;
    private Provider<AssetManager> getAssetManagerProvider;
    private Provider<DeviceInfo> getDeviceInfoProvider;
    private Provider<ConfigurationCompositor> getConfigurationCompositorProvider;
    private Provider<TasksFactory> getTasksFactoryProvider;
    private Provider<EventsFactory> provideEventsFactoryProvider;
    private Provider<JsonProxy> provideProxyProvider;
    private Provider<Session> provideSessionProvider;
    private Provider<HttpConnection> provideConnectorProvider;
    private Provider<ViewUtil> getViewUtilProvider;
    private Provider<PathGenerator> providePathGeneratorProvider;
    private Provider<UriBuilder> getUriBuilderProvider;
    private Provider<ScreenRecorder> provideScreenRecorderProvider;
    private Provider<PathDescriptor> providePathDescriptorProvider;
    private Provider<IScreenMonitoringService> provideScreenMonitoringServiceProvider;
    private MembersInjector<CsComponentChange> csComponentChangeMembersInjector;
    private Provider<ThreadExecutor> provideThreadPoolProvider;
    private MembersInjector<com.contentsquare.android.internal.events.processing.NetworkTransaction> networkTransactionMembersInjector;
    private MembersInjector<NetworkTransaction> networkTransactionMembersInjector2;
    private MembersInjector<TreeTraverser> treeTraverserMembersInjector;

    private DaggerSessionComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(final Builder builder) {
        this.getApplicationProvider = new Factory<Application>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public Application get() {
                return (Application)Preconditions.checkNotNull((Object)this.applicationComponent.getApplication(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.getPrefsHelperProvider = new Factory<PrefsHelper>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public PrefsHelper get() {
                return (PrefsHelper)Preconditions.checkNotNull((Object)this.applicationComponent.getPrefsHelper(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.provideGlassProvider = DoubleCheck.provider(TrackingModule_ProvideGlassFactory.create(builder.trackingModule, this.getApplicationProvider));
        this.provideProcessorProvider = DoubleCheck.provider(TrackingModule_ProvideProcessorFactory.create(builder.trackingModule, this.getApplicationProvider));
        this.getAssetManagerProvider = new Factory<AssetManager>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public AssetManager get() {
                return (AssetManager)Preconditions.checkNotNull((Object)this.applicationComponent.getAssetManager(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.getDeviceInfoProvider = new Factory<DeviceInfo>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public DeviceInfo get() {
                return (DeviceInfo)Preconditions.checkNotNull((Object)this.applicationComponent.getDeviceInfo(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.getConfigurationCompositorProvider = new Factory<ConfigurationCompositor>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public ConfigurationCompositor get() {
                return (ConfigurationCompositor)Preconditions.checkNotNull((Object)this.applicationComponent.getConfigurationCompositor(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.getTasksFactoryProvider = new Factory<TasksFactory>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public TasksFactory get() {
                return (TasksFactory)Preconditions.checkNotNull((Object)this.applicationComponent.getTasksFactory(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.provideEventsFactoryProvider = DoubleCheck.provider(TrackingModule_ProvideEventsFactoryFactory.create(builder.trackingModule));
        this.provideProxyProvider = DoubleCheck.provider(TrackingModule_ProvideProxyFactory.create(builder.trackingModule));
        this.provideSessionProvider = DoubleCheck.provider(SessionModule_ProvideSessionFactory.create(builder.sessionModule, this.getApplicationProvider, this.getPrefsHelperProvider, this.provideGlassProvider, this.provideProcessorProvider, this.getAssetManagerProvider, this.getDeviceInfoProvider, this.getConfigurationCompositorProvider, this.getTasksFactoryProvider, this.provideEventsFactoryProvider, this.provideProxyProvider));
        this.provideConnectorProvider = HttpModule_ProvideConnectorFactory.create(builder.httpModule);
        this.getViewUtilProvider = new Factory<ViewUtil>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public ViewUtil get() {
                return (ViewUtil)Preconditions.checkNotNull((Object)this.applicationComponent.getViewUtil(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.providePathGeneratorProvider = DoubleCheck.provider(SessionModule_ProvidePathGeneratorFactory.create(builder.sessionModule, this.getApplicationProvider, this.getViewUtilProvider));
        this.getUriBuilderProvider = new Factory<UriBuilder>(){
            private final ApplicationComponent applicationComponent;
            {
                this.applicationComponent = builder.applicationComponent;
            }

            public UriBuilder get() {
                return (UriBuilder)Preconditions.checkNotNull((Object)this.applicationComponent.getUriBuilder(), (String)"Cannot return null from a non-@Nullable component method");
            }
        };
        this.provideScreenRecorderProvider = DoubleCheck.provider(SessionModule_ProvideScreenRecorderFactory.create(builder.sessionModule, this.getDeviceInfoProvider, this.provideSessionProvider, this.getUriBuilderProvider, this.getViewUtilProvider));
        this.providePathDescriptorProvider = SessionUtilitiesModule_ProvidePathDescriptorFactory.create(builder.sessionUtilitiesModule);
        this.provideScreenMonitoringServiceProvider = DoubleCheck.provider(ScreenMonitoringModule_ProvideScreenMonitoringServiceFactory.create(builder.screenMonitoringModule));
        this.csComponentChangeMembersInjector = CsComponentChange_MembersInjector.create(this.provideSessionProvider);
        this.provideThreadPoolProvider = AsyncModule_ProvideThreadPoolFactory.create(builder.asyncModule);
        this.networkTransactionMembersInjector = com.contentsquare.android.internal.events.processing.NetworkTransaction_MembersInjector.create(this.provideThreadPoolProvider);
        this.networkTransactionMembersInjector2 = NetworkTransaction_MembersInjector.create(this.provideThreadPoolProvider);
        this.treeTraverserMembersInjector = TreeTraverser_MembersInjector.create(this.getDeviceInfoProvider, this.getApplicationProvider, this.getViewUtilProvider);
    }

    @Override
    public Session getSession() {
        return (Session)this.provideSessionProvider.get();
    }

    @Override
    public HttpConnection getHttpConnection() {
        return (HttpConnection)this.provideConnectorProvider.get();
    }

    @Override
    public PathGenerator getPathGenerator() {
        return (PathGenerator)this.providePathGeneratorProvider.get();
    }

    @Override
    public Application getApplication() {
        return (Application)this.getApplicationProvider.get();
    }

    @Override
    public ScreenRecorder getScreenRecorder() {
        return (ScreenRecorder)this.provideScreenRecorderProvider.get();
    }

    @Override
    public PathDescriptor getPathDescriptor() {
        return (PathDescriptor)this.providePathDescriptorProvider.get();
    }

    @Override
    public IScreenMonitoringService getScreenMonitoringService() {
        return (IScreenMonitoringService)this.provideScreenMonitoringServiceProvider.get();
    }

    @Override
    public EventsProcessor getEventsProcessor() {
        return (EventsProcessor)this.provideProcessorProvider.get();
    }

    @Override
    public JsonProxy getJsonProxy() {
        return (JsonProxy)this.provideProxyProvider.get();
    }

    @Override
    public void inject(CsActivityCallbacks csActivityCallbacks) {
        MembersInjectors.noOp().injectMembers((Object)csActivityCallbacks);
    }

    @Override
    public void inject(CsComponentChange csComponentChange) {
        this.csComponentChangeMembersInjector.injectMembers((Object)csComponentChange);
    }

    @Override
    public void inject(com.contentsquare.android.internal.events.processing.NetworkTransaction networkTransaction) {
        this.networkTransactionMembersInjector.injectMembers((Object)networkTransaction);
    }

    @Override
    public void inject(NetworkTransaction networkTransaction) {
        this.networkTransactionMembersInjector2.injectMembers((Object)networkTransaction);
    }

    @Override
    public void inject(TreeTraverser treeTraverser) {
        this.treeTraverserMembersInjector.injectMembers((Object)treeTraverser);
    }

    @Override
    public void inject(PathGenerator pathGenerator) {
        MembersInjectors.noOp().injectMembers((Object)pathGenerator);
    }

    public static final class Builder {
        private TrackingModule trackingModule;
        private SessionModule sessionModule;
        private HttpModule httpModule;
        private SessionUtilitiesModule sessionUtilitiesModule;
        private ScreenMonitoringModule screenMonitoringModule;
        private AsyncModule asyncModule;
        private ApplicationComponent applicationComponent;

        private Builder() {
        }

        public SessionComponent build() {
            if (this.trackingModule == null) {
                this.trackingModule = new TrackingModule();
            }
            if (this.sessionModule == null) {
                throw new IllegalStateException(SessionModule.class.getCanonicalName() + " must be set");
            }
            if (this.httpModule == null) {
                this.httpModule = new HttpModule();
            }
            if (this.sessionUtilitiesModule == null) {
                this.sessionUtilitiesModule = new SessionUtilitiesModule();
            }
            if (this.screenMonitoringModule == null) {
                this.screenMonitoringModule = new ScreenMonitoringModule();
            }
            if (this.asyncModule == null) {
                this.asyncModule = new AsyncModule();
            }
            if (this.applicationComponent == null) {
                throw new IllegalStateException(ApplicationComponent.class.getCanonicalName() + " must be set");
            }
            return new DaggerSessionComponent(this);
        }

        public Builder sessionModule(SessionModule sessionModule) {
            this.sessionModule = (SessionModule)Preconditions.checkNotNull((Object)sessionModule);
            return this;
        }

        public Builder httpModule(HttpModule httpModule) {
            this.httpModule = (HttpModule)Preconditions.checkNotNull((Object)httpModule);
            return this;
        }

        public Builder trackingModule(TrackingModule trackingModule) {
            this.trackingModule = (TrackingModule)Preconditions.checkNotNull((Object)trackingModule);
            return this;
        }

        public Builder asyncModule(AsyncModule asyncModule) {
            this.asyncModule = (AsyncModule)Preconditions.checkNotNull((Object)asyncModule);
            return this;
        }

        public Builder screenMonitoringModule(ScreenMonitoringModule screenMonitoringModule) {
            this.screenMonitoringModule = (ScreenMonitoringModule)Preconditions.checkNotNull((Object)screenMonitoringModule);
            return this;
        }

        public Builder sessionUtilitiesModule(SessionUtilitiesModule sessionUtilitiesModule) {
            this.sessionUtilitiesModule = (SessionUtilitiesModule)Preconditions.checkNotNull((Object)sessionUtilitiesModule);
            return this;
        }

        public Builder applicationComponent(ApplicationComponent applicationComponent) {
            this.applicationComponent = (ApplicationComponent)Preconditions.checkNotNull((Object)applicationComponent);
            return this;
        }
    }
}

