/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.dagger.session;

import android.app.Application;
import android.support.annotation.NonNull;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.UserScope;
import com.contentsquare.android.internal.events.processing.EventsProcessor;
import com.contentsquare.android.internal.factories.TasksFactory;
import com.contentsquare.android.internal.model.EventsFactory;
import com.contentsquare.android.internal.model.JsonProxy;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.screengraph.PathGenerator;
import com.contentsquare.android.internal.ui.glasspane.IGlassPane;
import com.contentsquare.android.internal.util.AssetManager;
import com.contentsquare.android.internal.util.ScreenRecorder;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.util.ViewUtil;
import dagger.Module;
import dagger.Provides;

@Module
public class SessionModule {
    private final String mProjectId;

    public SessionModule(@NonNull String projectId) {
        this.mProjectId = projectId;
    }

    @Provides
    @UserScope
    @NonNull
    Session provideSession(@NonNull Application application, @NonNull PrefsHelper prefsHelper, @NonNull IGlassPane glassPane, @NonNull EventsProcessor eventsProcessor, @NonNull AssetManager assets, @NonNull DeviceInfo deviceInfo, @NonNull ConfigurationCompositor compositor, @NonNull TasksFactory tasksFactory, @NonNull EventsFactory eventsFactory, @NonNull JsonProxy jsonProxy) {
        return new Session(application, this.mProjectId, prefsHelper, glassPane, eventsProcessor, assets, deviceInfo, compositor, tasksFactory, eventsFactory, jsonProxy);
    }

    @Provides
    @UserScope
    @NonNull
    public PathGenerator providePathGenerator(@NonNull Application application, @NonNull ViewUtil viewUtil) {
        return new PathGenerator(application, viewUtil);
    }

    @Provides
    @UserScope
    @NonNull
    public ScreenRecorder provideScreenRecorder(@NonNull DeviceInfo deviceInfo, @NonNull Session session, @NonNull UriBuilder uriBuilder, @NonNull ViewUtil viewUtil) {
        return new ScreenRecorder(deviceInfo, session, uriBuilder, viewUtil);
    }
}

