/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.events.processing;

import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.Pair;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.FileStorageUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class EventStorageManager {
    private final FileStorageUtil mStorageUtil;
    private final Logger mLogger = new Logger("EventStorageManager");
    @VisibleForTesting
    int mFilename = 0;
    @VisibleForTesting
    String mAppFilesLocation = null;
    @VisibleForTesting
    int mActiveBucketCurrentSize = 0;

    public EventStorageManager(Context context) {
        this.mStorageUtil = new FileStorageUtil();
        this.mAppFilesLocation = context.getFilesDir().getAbsolutePath();
    }

    public EventStorageManager(@NonNull FileStorageUtil storageUtil) {
        this.mStorageUtil = storageUtil;
    }

    int getActiveBucketSize() {
        return this.mActiveBucketCurrentSize;
    }

    @VisibleForTesting
    int getUnsentBucketsSize(int sessionId) {
        return this.mStorageUtil.getNumberOfItemsInFolder(String.valueOf(sessionId));
    }

    void addToActiveBucket(@IntRange(from=0L) int sessionId, @NonNull JSONObject event) {
        String jsonString = event.toString();
        this.sessionPrepare(sessionId);
        this.storeEventForSession(sessionId, jsonString);
    }

    int getActiveBucketId() {
        return this.mFilename;
    }

    private void sessionPrepare(int sessionId) {
        boolean resetNeeded = this.mStorageUtil.prepareAndReset(sessionId, this.mAppFilesLocation);
        if (resetNeeded) {
            this.mFilename = 0;
            this.mActiveBucketCurrentSize = 0;
        }
        this.mStorageUtil.prepareFile(String.valueOf(sessionId), String.valueOf(this.mFilename));
    }

    private void storeEventForSession(int sessionId, String jsonString) {
        this.mStorageUtil.appendStringToFile(String.valueOf(sessionId), String.valueOf(this.mFilename), jsonString);
        ++this.mActiveBucketCurrentSize;
    }

    @VisibleForTesting
    List<JSONObject> getBucketContent(@IntRange(from=0L) int sessionId, @IntRange(from=0L) int activeBucketId) {
        List<String> lines = this.mStorageUtil.readFileContentByLine(String.valueOf(sessionId), String.valueOf(activeBucketId));
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(lines.size());
        for (String stringItem : lines) {
            try {
                result.add(new JSONObject(stringItem));
            }
            catch (JSONException e) {
                this.mLogger.e(e, "DATALOSS : Failed to serialize string to JSon Object", new Object[0]);
            }
        }
        return result;
    }

    @VisibleForTesting
    void resetActiveBucket() {
        this.mActiveBucketCurrentSize = 0;
        ++this.mFilename;
    }

    void deleteBucket(@IntRange(from=0L) int sessionId, @IntRange(from=0L) int filename) {
        this.mStorageUtil.deleteFile(String.valueOf(sessionId), String.valueOf(filename));
        this.mStorageUtil.cleanupFolder(String.valueOf(sessionId));
    }

    @NonNull
    public List<Pair<Integer, Integer>> getAllUnsentData() {
        String[] sessionsLocations;
        LinkedList<Pair<Integer, Integer>> result = new LinkedList<Pair<Integer, Integer>>();
        for (String session : sessionsLocations = this.listAllSessionsInStorage()) {
            File sessionFoler = new File(session);
            if (this.isValidSession(sessionFoler)) {
                File[] batch;
                this.mLogger.w("Unsent session: %s - with path %s", sessionFoler.getName(), sessionFoler.getPath());
                int sessionId = Integer.parseInt(sessionFoler.getName());
                for (File bucket : batch = this.getBucketBatch(sessionFoler)) {
                    this.mLogger.w("Unsent bucket: %s - with path %s", bucket.getName(), bucket.getPath());
                    int bucketId = Integer.parseInt(bucket.getName());
                    result.add((Pair<Integer, Integer>)new Pair((Object)sessionId, (Object)bucketId));
                }
                continue;
            }
            this.mLogger.e("Error : Cannot read folder! %s", sessionFoler.getAbsolutePath());
        }
        return result;
    }

    @NonNull
    private String[] listAllSessionsInStorage() {
        return this.mStorageUtil.getMainDirectoryList();
    }

    private boolean isValidSession(File unsentSession) {
        return this.mStorageUtil.isDirectory(unsentSession) && this.mStorageUtil.readable(unsentSession);
    }

    private File[] getBucketBatch(File file) {
        return this.mStorageUtil.getFileList(file);
    }
}

