/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.events.processing;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.Pair;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.events.processing.EventStorageManager;
import com.contentsquare.android.internal.events.processing.NetworkTransaction;
import com.contentsquare.android.internal.logging.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class EventsProcessor {
    private static final int DEFAULT_SIZE = 100;
    private final Logger mLogger = new Logger("EventsProcessor");
    private final EventStorageManager mEventStorage;
    @VisibleForTesting
    int mMaxBucketSize = 100;
    @VisibleForTesting
    Map<String, Pair<Integer, Integer>> mInProcessBuckets = new HashMap<String, Pair<Integer, Integer>>();
    private int mSessionId;

    public EventsProcessor(@NonNull EventStorageManager eventStorage) {
        this.mEventStorage = eventStorage;
    }

    public void processEvent(@Nullable JSONObject event) {
        this.mLogger.i("[new format] Event received Bucket size =%d  max size = %d", this.mEventStorage.getActiveBucketSize(), this.mMaxBucketSize);
        if (event == null) {
            this.mLogger.d("Event is null exiting", new Object[0]);
            return;
        }
        this.mLogger.d("processing event: %s", event.toString());
        this.mEventStorage.addToActiveBucket(this.mSessionId, event);
        if (this.mEventStorage.getActiveBucketSize() >= this.mMaxBucketSize) {
            this.processMainBucket();
        }
    }

    @VisibleForTesting
    void processMainBucket() {
        this.mLogger.i("MAIN bucket: bucket reached maxSize, processing events and creating a new bucket", new Object[0]);
        boolean secondaryBatch = false;
        this.processBucket(this.mSessionId, this.mEventStorage.getActiveBucketId(), secondaryBatch);
        this.mEventStorage.resetActiveBucket();
    }

    public void flushPendingEvents() {
        this.processMainBucket();
    }

    @VisibleForTesting
    void processBucket(int sessionId, int activeBucketId, boolean processInBatch) {
        this.mLogger.w("processing received session %d, bucket of %d .", sessionId, activeBucketId);
        NetworkTransaction transaction = this.createTransaction(sessionId, activeBucketId, processInBatch);
        this.moveToInprocess(transaction, sessionId, activeBucketId);
        transaction.execute();
    }

    private void moveToInprocess(NetworkTransaction transaction, int sessionId, int activeBucketId) {
        this.mInProcessBuckets.put(transaction.getId(), (Pair<Integer, Integer>)new Pair((Object)sessionId, (Object)activeBucketId));
    }

    @NonNull
    @VisibleForTesting
    NetworkTransaction createTransaction(@IntRange(from=0L) int sessionId, @IntRange(from=0L) int activeBucketId, boolean secondaryBatch) {
        List<JSONObject> bucket = this.mEventStorage.getBucketContent(sessionId, activeBucketId);
        Session session = SingletonProvider.getSessionComponent().getSession();
        return new NetworkTransaction(session, bucket, secondaryBatch, SingletonProvider.getAppComponent().getUriBuilder());
    }

    void failTransaction(String id2) {
        this.mLogger.i("Received a failed transaction with id : %s, moving to unsent data", id2);
        this.mInProcessBuckets.remove(id2);
    }

    void passTransaction(@NonNull String id2) {
        this.processSentBuckets(id2);
    }

    void passTransactionAndGotoNextBatch(@NonNull String id2) {
        this.processSentBuckets(id2);
        this.mLogger.i("starting to process unsent buckets, current bucket : %s", id2);
        this.processUsentBuckets();
    }

    private void processUsentBuckets() {
        this.mLogger.i("processing unsent buckets", new Object[0]);
        List<Pair<Integer, Integer>> batchesToProcess = this.mEventStorage.getAllUnsentData();
        for (Pair<Integer, Integer> pair : batchesToProcess) {
            int active = this.mEventStorage.getActiveBucketId();
            int session = this.mSessionId;
            if ((Integer)pair.first == session && (Integer)pair.second == active) {
                this.mLogger.i("Active buckets skipped session: %d - filename: %d ", session, active);
                continue;
            }
            boolean batch = true;
            this.processBucket((Integer)pair.first, (Integer)pair.second, batch);
        }
    }

    public void setBucketSize(int storageMaxItems) {
        this.mLogger.d("setting bucket size to %d", storageMaxItems);
        this.mMaxBucketSize = storageMaxItems;
    }

    int getMaxBucketSize() {
        return this.mMaxBucketSize;
    }

    @VisibleForTesting
    int getActiveBucketSize() {
        return this.mEventStorage.getActiveBucketSize();
    }

    public void setSessionId(@IntRange(from=0L) int sessionId) {
        this.mSessionId = sessionId;
    }

    private void processSentBuckets(@NonNull String id2) {
        this.mLogger.i("Passed transaction with id : %s, processing to unsent data", id2);
        Pair<Integer, Integer> item = this.mInProcessBuckets.get(id2);
        this.mInProcessBuckets.remove(id2);
        if (item != null) {
            this.mEventStorage.deleteBucket((Integer)item.first, (Integer)item.second);
        }
    }
}

