/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.events.processing;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.async.ThreadExecutor;
import com.contentsquare.android.internal.async.TransactionRunnable;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.model.JsonProxy;
import com.contentsquare.android.internal.model.data.EventsBundle;
import com.contentsquare.android.internal.util.HttpConnection;
import com.contentsquare.android.internal.util.UriBuilder;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.json.JSONObject;

public class NetworkTransaction {
    private final Session mSession;
    private final String mId;
    @Inject
    ThreadExecutor mExecutor;
    @VisibleForTesting
    boolean mBatch = false;
    private final List<JSONObject> mBucket;
    private final Logger mLogger = new Logger("NetworkTransaction");
    @NonNull
    private final UriBuilder mUriBuilder;

    NetworkTransaction(@NonNull Session session, @NonNull List<JSONObject> bucket, boolean isBatch, @NonNull UriBuilder uriBuilder) {
        this.mUriBuilder = uriBuilder;
        SingletonProvider.getSessionComponent().inject(this);
        this.mId = UUID.randomUUID().toString();
        this.mLogger.d("New Transaction created. Uid : %s", this.mId);
        this.mBucket = bucket;
        this.mBatch = isBatch;
        this.mSession = session;
    }

    public String getId() {
        return this.mId;
    }

    public void execute() {
        this.scheduleSend();
    }

    @VisibleForTesting
    void scheduleSend() {
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public void rollBack() {
                NetworkTransaction.this.fail();
            }

            @Override
            public void run() {
                NetworkTransaction.this.mLogger.i("Calling HTTP request for bucket of %d items", NetworkTransaction.this.mBucket.size());
                JsonProxy proxy = NetworkTransaction.this.mSession.getJsonProxy();
                JSONObject jsonData = proxy.serializeToJson(NetworkTransaction.this.getBundle());
                if (jsonData == null) {
                    NetworkTransaction.this.fail();
                    return;
                }
                String endpoint = NetworkTransaction.this.mSession.getRunConfiguration().getCollectorEndpoint();
                HttpConnection.HttpResponse result = NetworkTransaction.this.getHttpConnection().performPostWithJson(NetworkTransaction.this.mUriBuilder.buildEventsUrl(endpoint), jsonData);
                if (result.positive()) {
                    NetworkTransaction.this.pass();
                } else {
                    NetworkTransaction.this.fail();
                }
            }
        };
        boolean dispatchSuccessful = this.mExecutor.dispatch(runnable);
        if (!dispatchSuccessful) {
            this.mLogger.w("dispatch not successful, failing!", new Object[0]);
            this.fail();
        } else {
            this.mLogger.w("dispatch success, should exec soon!", new Object[0]);
        }
    }

    @NonNull
    EventsBundle getBundle() {
        return new EventsBundle.BundleBuilder().setPayload(this.mBucket).build();
    }

    @VisibleForTesting
    HttpConnection getHttpConnection() {
        return new HttpConnection();
    }

    @VisibleForTesting
    void fail() {
        this.mLogger.w("dispatching runnable was unscuccessful, failing this transaction.", new Object[0]);
        this.mSession.getEventsProcessor().failTransaction(this.mId);
    }

    @VisibleForTesting
    void pass() {
        if (this.mBatch) {
            this.mLogger.w("SencondaryBatch Transaction passed, triggering cleanup in events processor", new Object[0]);
            this.mSession.getEventsProcessor().passTransaction(this.mId);
        } else {
            this.mLogger.w("PrimaryBatch Transaction passed, triggering cleanup in events processor", new Object[0]);
            this.mSession.getEventsProcessor().passTransactionAndGotoNextBatch(this.mId);
        }
    }

    public List<JSONObject> getData() {
        return this.mBucket;
    }
}

