/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.listeners;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.dagger.session.SessionComponent;
import com.contentsquare.android.internal.listeners.CsActivityCallbacks$AjcClosure1;
import com.contentsquare.android.internal.listeners.CsActivityCallbacks$AjcClosure3;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.model.JsonProxy;
import com.contentsquare.android.internal.model.data.AppExitEvent;
import com.contentsquare.android.internal.model.data.AppHideEvent;
import com.contentsquare.android.internal.model.data.AppShowEvent;
import com.contentsquare.android.internal.model.data.AppStartEvent;
import com.contentsquare.android.internal.model.data.PageViewEvent;
import com.contentsquare.android.internal.screengraph.PathGenerator;
import com.contentsquare.android.internal.screenmonitoring.IScreenChangedCallback;
import com.contentsquare.android.internal.screenmonitoring.IScreenMonitoringService;
import com.contentsquare.android.internal.util.FrameworkUtility;
import hugo.weaving.DebugLog;
import hugo.weaving.internal.Hugo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CsActivityCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static final long HIDE_TIMEOUT = 5000L;
    private static final long EXIT_TIMEOUT = 60000L;
    @VisibleForTesting
    @NonNull
    final IScreenMonitoringService mScreenMonitoringService;
    @VisibleForTesting
    @NonNull
    final PathGenerator mPathGenerator;
    @NonNull
    private final Logger mLogger = new Logger("Callbacks");
    @NonNull
    private final IScreenChangedCallback mScreenChangedCallback;
    @NonNull
    Session mSession;
    @VisibleForTesting
    Activity mLiveActivity;
    @VisibleForTesting
    Handler mHandler;
    @VisibleForTesting
    Runnable mHideRunnable;
    @VisibleForTesting
    Runnable mExitRunnable;
    @VisibleForTesting
    long mExitTimestamp;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public CsActivityCallbacks() {
        SessionComponent sessionComponent = SingletonProvider.getSessionComponent();
        this.mScreenMonitoringService = sessionComponent.getScreenMonitoringService();
        this.mPathGenerator = sessionComponent.getPathGenerator();
        this.mSession = sessionComponent.getSession();
        sessionComponent.inject(this);
        this.mHandler = new Handler();
        this.mLogger.d("sending start event", new Object[0]);
        this.mScreenChangedCallback = new ScreenChangedCallback(this.mPathGenerator, this.mSession, this.mLogger);
        AppStartEvent.AppStartEventBuilder start = (AppStartEvent.AppStartEventBuilder)this.mSession.getEventsFactory().produceEvent(0);
        this.mSession.getEventsProcessor().processEvent(this.mSession.getJsonProxy().serializeToJson(start.build()));
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    @DebugLog
    public void onActivityResumed(Activity activity) {
        Activity activity2 = activity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)activity2);
        Object[] objectArray = new Object[]{this, activity2, joinPoint};
        Hugo.aspectOf().logAndExecute(new CsActivityCallbacks$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @DebugLog
    public void onActivityPaused(Activity activity) {
        Activity activity2 = activity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)activity2);
        Object[] objectArray = new Object[]{this, activity2, joinPoint};
        Hugo.aspectOf().logAndExecute(new CsActivityCallbacks$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    @NonNull
    public Session getSession() {
        return this.mSession;
    }

    public Activity getLiveActivity() {
        return this.mLiveActivity;
    }

    static {
        CsActivityCallbacks.ajc$preClinit();
    }

    static final /* synthetic */ void onActivityResumed_aroundBody0(CsActivityCallbacks ajc$this, Activity activity, JoinPoint joinPoint) {
        FrameLayout rootView;
        int loadTime;
        if (ajc$this.mExitTimestamp == 0L) {
            loadTime = 0;
            AppShowEvent.AppShowEventBuilder show = (AppShowEvent.AppShowEventBuilder)ajc$this.mSession.getEventsFactory().produceEvent(1);
            ajc$this.mSession.getEventsProcessor().processEvent(ajc$this.mSession.getJsonProxy().serializeToJson(show.build()));
        } else {
            loadTime = (int)(System.currentTimeMillis() - ajc$this.mExitTimestamp);
        }
        ajc$this.mLiveActivity = activity;
        String url = null;
        Window window = activity.getWindow();
        if (window != null && (rootView = (FrameLayout)window.findViewById(0x1020002)) != null) {
            url = ajc$this.mPathGenerator.generateUrl(activity, (ViewGroup)rootView);
        }
        ajc$this.getSession().getGlass().setCurrentScreenUrl(url);
        ajc$this.getSession().attachGlassPane(ajc$this.mLiveActivity);
        ajc$this.mLogger.d("sending show event", new Object[0]);
        if (ajc$this.mScreenMonitoringService.attachTo(ajc$this.mLiveActivity, ajc$this.mScreenChangedCallback)) {
            ajc$this.mLogger.d("ScreenMonitorService: the Activity %s is  being monitored.", ajc$this.mLiveActivity.getTitle());
        }
        PageViewEvent.PageViewBuilder builder = (PageViewEvent.PageViewBuilder)ajc$this.getSession().produceEventBuilder(4);
        builder.setLoadTime(loadTime).setTitle(FrameworkUtility.getActivityTitle(activity));
        PageViewEvent event = builder.build();
        JsonProxy proxy = ajc$this.getSession().getJsonProxy();
        ajc$this.getSession().getEventsProcessor().processEvent(proxy.serializeToJson(event));
        if (ajc$this.mHideRunnable != null) {
            ajc$this.mLogger.d("canceling hide event event", new Object[0]);
            ajc$this.mHandler.removeCallbacks(ajc$this.mHideRunnable);
        }
        if (ajc$this.mExitRunnable != null) {
            ajc$this.mLogger.d("canceling exit event event", new Object[0]);
            ajc$this.mHandler.removeCallbacks(ajc$this.mExitRunnable);
        }
    }

    static final /* synthetic */ void onActivityPaused_aroundBody2(CsActivityCallbacks ajc$this, Activity activity, JoinPoint joinPoint) {
        ajc$this.mExitTimestamp = System.currentTimeMillis();
        ajc$this.getSession().detachGlassPane(ajc$this.mLiveActivity);
        if (activity != null) {
            ajc$this.mScreenMonitoringService.detachFrom(activity);
        } else {
            ajc$this.mLogger.d("[onActivityPaused] : the Activity was null when trying to call #detachFrom on ScreenMonitoringService", new Object[0]);
        }
        ajc$this.mLiveActivity = null;
        ajc$this.getSession().getGlass().setCurrentScreenUrl(null);
        ajc$this.mHideRunnable = new Runnable(){

            @Override
            public void run() {
                CsActivityCallbacks.this.mLogger.d("sending hide event", new Object[0]);
                AppHideEvent.AppHideEventBuilder hideBuilder = (AppHideEvent.AppHideEventBuilder)CsActivityCallbacks.this.mSession.getEventsFactory().produceEvent(2);
                CsActivityCallbacks.this.mSession.getEventsProcessor().processEvent(CsActivityCallbacks.this.mSession.getJsonProxy().serializeToJson(hideBuilder.build()));
                CsActivityCallbacks.this.mHideRunnable = null;
                CsActivityCallbacks.this.getSession().getEventsProcessor().flushPendingEvents();
            }
        };
        ajc$this.mLogger.d("scheduling hide", new Object[0]);
        ajc$this.mHandler.postDelayed(ajc$this.mHideRunnable, 5000L);
        ajc$this.mExitRunnable = new Runnable(){

            @Override
            public void run() {
                CsActivityCallbacks.this.mLogger.d("sending exit event", new Object[0]);
                AppExitEvent.AppExitEventBuilder exit = (AppExitEvent.AppExitEventBuilder)CsActivityCallbacks.this.mSession.getEventsFactory().produceEvent(3);
                CsActivityCallbacks.this.mSession.getEventsProcessor().processEvent(CsActivityCallbacks.this.mSession.getJsonProxy().serializeToJson(exit.build()));
                CsActivityCallbacks.this.mExitRunnable = null;
                CsActivityCallbacks.this.getSession().getEventsProcessor().flushPendingEvents();
            }
        };
        ajc$this.mLogger.d("scheduling exit", new Object[0]);
        ajc$this.mHandler.postDelayed(ajc$this.mExitRunnable, 60000L);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CsActivityCallbacks.java", CsActivityCallbacks.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onActivityResumed", "com.contentsquare.android.internal.listeners.CsActivityCallbacks", "android.app.Activity", "activity", "", "void"), 112);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onActivityPaused", "com.contentsquare.android.internal.listeners.CsActivityCallbacks", "android.app.Activity", "activity", "", "void"), 163);
    }

    static class ScreenChangedCallback
    implements IScreenChangedCallback {
        @NonNull
        private final PathGenerator mPathGenerator;
        @NonNull
        private final Session mSession;
        @NonNull
        private final Logger mLogger;

        ScreenChangedCallback(@NonNull PathGenerator pathGenerator, @NonNull Session session, @NonNull Logger logger) {
            this.mPathGenerator = pathGenerator;
            this.mSession = session;
            this.mLogger = logger;
        }

        @Override
        public void onScreenChanged(@NonNull Activity activity, @NonNull Fragment fragment, int loadingTime) {
            Window window = activity.getWindow();
            if (window != null) {
                ViewGroup rootView = (ViewGroup)window.findViewById(0x1020002);
                String url = this.mPathGenerator.generateUrl(activity, fragment, rootView);
                this.mSession.getGlass().setCurrentScreenUrl(url);
                this.sendNewPageViewEvent(activity, this.mSession, loadingTime);
            } else {
                String warningLogFormat = "[OnScreenChanged]: Was called for activity: [%s]  but the activity did not have a Window";
                String activityName = activity.getClass().getSimpleName();
                this.mLogger.w("[OnScreenChanged]: Was called for activity: [%s]  but the activity did not have a Window", activityName);
            }
        }

        private void sendNewPageViewEvent(@NonNull Activity activity, @NonNull Session session, int loadingTime) {
            PageViewEvent.PageViewBuilder builder = (PageViewEvent.PageViewBuilder)session.produceEventBuilder(4);
            builder.setLoadTime(loadingTime).setTitle(FrameworkUtility.getActivityTitle(activity));
            PageViewEvent event = builder.build();
            JsonProxy proxy = session.getJsonProxy();
            session.getEventsProcessor().processEvent(proxy.serializeToJson(event));
        }
    }
}

