/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.listeners;

import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.support.annotation.NonNull;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.dagger.session.SessionComponent;
import com.contentsquare.android.internal.events.processing.EventsProcessor;
import com.contentsquare.android.internal.model.data.LowMemoryEvent;
import javax.inject.Inject;
import org.json.JSONObject;

public class CsComponentChange
implements ComponentCallbacks {
    @Inject
    protected Session mSession;

    public CsComponentChange() {
        SingletonProvider.getSessionComponent().inject(this);
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
    }

    public void onLowMemory() {
        this.dispatchLowMemoryEvent();
        this.mSession.stopSession();
    }

    private void dispatchLowMemoryEvent() {
        Runtime process = Runtime.getRuntime();
        DeviceInfo deviceInfo = SingletonProvider.getAppComponent().getDeviceInfo();
        SessionComponent sessionComponent = SingletonProvider.getSessionComponent();
        int availableFreeProcessMemory = deviceInfo.getCurrentAvailableFreeHeapMemory(process);
        LowMemoryEvent lowMemoryEvent = new LowMemoryEvent.LowMemoryEventBuilder().currentAvailableMemory(availableFreeProcessMemory).build();
        JSONObject toSend = sessionComponent.getJsonProxy().serializeToJson(lowMemoryEvent);
        if (toSend != null) {
            EventsProcessor eventsProcessor = this.mSession.getEventsProcessor();
            eventsProcessor.processEvent(toSend);
        }
    }
}

