/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.logging;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.contentsquare.android.BuildConfig;

@SuppressLint(value={"all"})
public class Logger {
    @VisibleForTesting
    static boolean sLogEnabled = false;
    private final String mTag;

    public Logger(String tag) {
        this.mTag = tag;
    }

    @VisibleForTesting
    public static boolean isLogEnabled() {
        return sLogEnabled;
    }

    static void setLogEnabled(boolean enableLogs) {
        sLogEnabled = enableLogs;
    }

    public static void init() {
        Log.e((String)"cs", (String)("LoggingFacility enabled : " + BuildConfig.DEBUG));
        if (BuildConfig.DEBUG) {
            Logger.setLogEnabled(true);
        }
    }

    public static void overrideLogging(boolean shouldLog) {
        Logger.setLogEnabled(shouldLog);
    }

    static int v(String tag, String msg) {
        if (sLogEnabled) {
            return Log.v((String)tag, (String)msg);
        }
        return -1;
    }

    static int v(String tag, String msg, Throwable tr) {
        if (sLogEnabled) {
            return Log.v((String)tag, (String)msg, (Throwable)tr);
        }
        return -1;
    }

    static int d(String tag, String msg) {
        if (sLogEnabled) {
            return Log.d((String)tag, (String)msg);
        }
        return -1;
    }

    static int d(String tag, String msg, Throwable tr) {
        if (sLogEnabled) {
            return Log.d((String)tag, (String)msg, (Throwable)tr);
        }
        return -1;
    }

    static int i(String tag, String msg) {
        if (sLogEnabled) {
            return Log.i((String)tag, (String)msg);
        }
        return -1;
    }

    static int i(String tag, String msg, Throwable tr) {
        if (sLogEnabled) {
            return Log.i((String)tag, (String)msg, (Throwable)tr);
        }
        return -1;
    }

    static int w(String tag, String msg) {
        if (sLogEnabled) {
            return Log.w((String)tag, (String)msg);
        }
        return -1;
    }

    static int w(String tag, String msg, Throwable tr) {
        if (sLogEnabled) {
            return Log.w((String)tag, (String)msg, (Throwable)tr);
        }
        return -1;
    }

    static int w(String tag, Throwable tr) {
        if (sLogEnabled) {
            return Log.w((String)tag, (String)"", (Throwable)tr);
        }
        return -1;
    }

    static int e(String tag, String msg) {
        if (sLogEnabled) {
            return Log.e((String)tag, (String)msg);
        }
        return -1;
    }

    static int e(String tag, String msg, Throwable tr) {
        if (sLogEnabled) {
            return Log.e((String)tag, (String)msg, (Throwable)tr);
        }
        return -1;
    }

    public void d(@NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.d(this.mTag, String.format(message, parameters));
        }
    }

    public void d(Throwable t, @NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.d(this.mTag, String.format(message, parameters), t);
        }
    }

    public void i(@NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.i(this.mTag, String.format(message, parameters));
        }
    }

    public void i(Throwable t, @NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.i(this.mTag, String.format(message, parameters), t);
        }
    }

    public void w(@NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.w(this.mTag, String.format(message, parameters));
        }
    }

    public void w(Throwable t, @NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.w(this.mTag, String.format(message, parameters), t);
        }
    }

    public void e(@NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.e(this.mTag, String.format(message, parameters));
        }
    }

    public void e(Throwable t, @NonNull String message, Object ... parameters) {
        if (sLogEnabled) {
            Logger.e(this.mTag, String.format(message, parameters), t);
        }
    }
}

