/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.BuildConfig;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.model.data.ActionEvent;
import com.contentsquare.android.internal.model.data.AppExitEvent;
import com.contentsquare.android.internal.model.data.AppHideEvent;
import com.contentsquare.android.internal.model.data.AppShowEvent;
import com.contentsquare.android.internal.model.data.AppStartEvent;
import com.contentsquare.android.internal.model.data.CrashEvent;
import com.contentsquare.android.internal.model.data.DoubleTapEvent;
import com.contentsquare.android.internal.model.data.DragEvent;
import com.contentsquare.android.internal.model.data.EventsBundle;
import com.contentsquare.android.internal.model.data.FlickEvent;
import com.contentsquare.android.internal.model.data.LongPressEvent;
import com.contentsquare.android.internal.model.data.LowMemoryEvent;
import com.contentsquare.android.internal.model.data.PageViewEvent;
import com.contentsquare.android.internal.model.data.TapEvent;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonProxy {
    public static final String LABEL_EVENT_UUID = "euid";
    public static final String LABEL_EVENT_ACTION = "ea";
    public static final String LABEL_URL = "url";
    static final String LABEL_SCREEN_NUMBER = "scn";
    static final String LABEL_CONNECTION_TYPE = "c";
    static final String LABEL_CARRIER_ID = "ci";
    static final String LABEL_BATTERY = "b";
    static final String LABEL_BATTERY_CHARGING = "bc";
    static final String LABEL_ORIENTATION = "o";
    static final String LABEL_VERSION_ORIGIN = "vo";
    static final String LABEL_SESSION_NUMBER = "sn";
    private static final String LABEL_TIMESTAMP = "t";
    static final String LABEL_PAGE_SCREEN_TITLE = "st";
    static final String LABEL_PAGE_LOAD_TIME = "sl";
    static final String LABEL_CRASH_MESSAGE = "m";
    static final String LABEL_CRASH_ORIGIN = "co";
    static final String LABEL_CRASH_FATAL = "cf";
    static final String BATCH_PROJECT_ID = "pid";
    static final String BATCH_USER_ID = "uid";
    static final String BATCH_DEVICE_TYPE = "dt";
    private static final String BATCH_OS_NAME = "os";
    static final String BATCH_LANGUAGE = "l";
    static final String BATCH_ANONIMIZER = "a";
    static final String BATCH_TIMEZONE = "tz";
    private static final String BATCH_TYPE_ORIGIN = "to";
    public static final String BATCH_APP_NAME = "an";
    public static final String BATCH_SDK_TYPE = "st";
    public static final String BATCH_SDK_FLAVOR = "sf";
    private static final String BATCH_DISPLAY_RESOLUTION = "r";
    public static final String BATCH_PAYLOAD = "pl";
    static final String LABEL_TAP_PATH = "tvp";
    static final String LABEL_TAP_LABEL = "tvt";
    static final String LABEL_TAP_VIEWID = "tvid";
    static final String LABEL_TAP_ACS_LABEL = "tvac";
    static final String LABEL_FINGER_DIRECTION = "fd";
    static final String LABEL_TARGET_VIEW_DISTANCE_DRAGGED = "tvd";
    static final String LABEL_TARGET_VIEW_VELOCITY = "tvv";
    public static final String LABEL_TAP_UNRESPONSIVE = "ur";
    public static final String LABEL_HEAP_MEMORY_LEVEL = "am";
    private final Logger mLog = new Logger("JsonProxy");

    @NonNull
    @VisibleForTesting
    JSONObject serializeSuper(@NonNull ActionEvent event) throws JSONException {
        JSONObject result = new JSONObject();
        result.put(LABEL_EVENT_UUID, (Object)event.getUuid());
        result.put(LABEL_EVENT_ACTION, event.getEventAction());
        result.put(LABEL_URL, (Object)event.getUrl());
        result.put(LABEL_SCREEN_NUMBER, event.getScreenCount());
        result.put(LABEL_CONNECTION_TYPE, event.getConnectionType());
        result.put(LABEL_CARRIER_ID, (Object)event.getCarrierId());
        result.put(LABEL_BATTERY, event.getBatteryLevel());
        result.put(LABEL_BATTERY_CHARGING, event.isBatteryCharging());
        result.put(LABEL_ORIENTATION, event.getOrientation());
        result.put(LABEL_VERSION_ORIGIN, (Object)event.getOriginVersion());
        result.put(LABEL_SESSION_NUMBER, event.getSessionNumber());
        result.put(LABEL_TIMESTAMP, event.getTimestamp());
        return result;
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull PageViewEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put("st", (Object)event.getTitle());
            obj.put(LABEL_PAGE_LOAD_TIME, event.getLoadTime());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[PageViewEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    JSONObject serializeToJson(@NonNull CrashEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_CRASH_MESSAGE, (Object)event.getMessage());
            obj.put(LABEL_CRASH_ORIGIN, event.getCrashOrigin());
            obj.put(LABEL_CRASH_FATAL, event.isFatal());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[CrashEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    JSONObject serializeToJson(@NonNull TapEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_TAP_PATH, (Object)event.getTouchPath());
            obj.put(LABEL_TAP_LABEL, (Object)event.getViewLabel());
            obj.put(LABEL_TAP_VIEWID, (Object)event.getViewId());
            obj.put(LABEL_TAP_ACS_LABEL, (Object)event.getViewAccessibilityLabel());
            obj.put(LABEL_TAP_UNRESPONSIVE, event.isTouchUnresponsive());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[TapEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    JSONObject serializeToJson(@NonNull DoubleTapEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_TAP_PATH, (Object)event.getTouchPath());
            obj.put(LABEL_TAP_LABEL, (Object)event.getViewLabel());
            obj.put(LABEL_TAP_VIEWID, (Object)event.getViewId());
            obj.put(LABEL_TAP_ACS_LABEL, (Object)event.getViewAccessibilityLabel());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[DoubleTapEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    JSONObject serializeToJson(@NonNull LongPressEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_TAP_PATH, (Object)event.getTouchPath());
            obj.put(LABEL_TAP_LABEL, (Object)event.getViewLabel());
            obj.put(LABEL_TAP_VIEWID, (Object)event.getViewId());
            obj.put(LABEL_TAP_ACS_LABEL, (Object)event.getViewAccessibilityLabel());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[LongPressEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    JSONObject serializeToJson(@NonNull FlickEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_TAP_PATH, (Object)event.getTouchPath());
            obj.put(LABEL_TAP_LABEL, (Object)event.getViewLabel());
            obj.put(LABEL_TAP_VIEWID, (Object)event.getViewId());
            obj.put(LABEL_TAP_ACS_LABEL, (Object)event.getViewAccessibilityLabel());
            obj.put(LABEL_FINGER_DIRECTION, event.getFingerDirection());
            obj.put(LABEL_TARGET_VIEW_DISTANCE_DRAGGED, event.getTargetViewDistanceDragged());
            obj.put(LABEL_TARGET_VIEW_VELOCITY, event.getTargetViewVelocity());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[FlickEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull DragEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_TAP_PATH, (Object)event.getTouchPath());
            obj.put(LABEL_TAP_LABEL, (Object)event.getViewLabel());
            obj.put(LABEL_TAP_VIEWID, (Object)event.getViewId());
            obj.put(LABEL_TAP_ACS_LABEL, (Object)event.getViewAccessibilityLabel());
            obj.put(LABEL_FINGER_DIRECTION, event.getFingerDirection());
            obj.put(LABEL_TARGET_VIEW_DISTANCE_DRAGGED, event.getTargetViewDistanceDragged());
            obj.put(LABEL_TARGET_VIEW_VELOCITY, event.getTargetViewVelocity());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[DragEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull LowMemoryEvent event) {
        try {
            JSONObject obj = this.serializeSuper(event);
            obj.put(LABEL_HEAP_MEMORY_LEVEL, event.getCurrentAvailableMemory());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[LowMemoryEvent] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull EventsBundle events) {
        try {
            JSONObject obj = new JSONObject();
            obj.put(BATCH_PROJECT_ID, events.getProjectId());
            obj.put(BATCH_USER_ID, (Object)events.getUserId());
            obj.put(BATCH_DEVICE_TYPE, events.getDeviceType());
            obj.put(BATCH_OS_NAME, (Object)events.getOsName());
            obj.put(BATCH_LANGUAGE, (Object)events.getDeviceLanguage());
            obj.put(BATCH_ANONIMIZER, events.isAnonymizerEnabled());
            obj.put(BATCH_TIMEZONE, (Object)events.getTimezone());
            obj.put(BATCH_TYPE_ORIGIN, (Object)events.getTypeOrigin());
            obj.put(BATCH_DISPLAY_RESOLUTION, (Object)events.getDeviceResolution());
            obj.put(BATCH_PAYLOAD, (Object)events.getPayload());
            return obj;
        }
        catch (JSONException e) {
            this.mLog.w(e, "[EventsBundle] Error in json proxy : %s", e.getMessage());
            return null;
        }
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull AppStartEvent event) {
        JSONObject obj = null;
        try {
            obj = this.serializeSuper(event);
        }
        catch (JSONException e) {
            this.mLog.w(e, "[AppStartEvent] Error in json proxy : %s", e.getMessage());
        }
        return obj;
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull AppShowEvent event) {
        JSONObject obj = null;
        try {
            obj = this.serializeSuper(event);
        }
        catch (JSONException e) {
            this.mLog.w(e, "[AppShowEvent] Error in json proxy : %s", e.getMessage());
        }
        return obj;
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull AppHideEvent event) {
        JSONObject obj = null;
        try {
            obj = this.serializeSuper(event);
        }
        catch (JSONException e) {
            this.mLog.w(e, "[AppHideEvent] Error in json proxy : %s", e.getMessage());
        }
        return obj;
    }

    @Nullable
    public JSONObject serializeToJson(@NonNull AppExitEvent event) {
        JSONObject obj = null;
        try {
            obj = this.serializeSuper(event);
        }
        catch (JSONException e) {
            this.mLog.w(e, "[AppExitEvent] Error in json proxy : %s", e.getMessage());
        }
        return obj;
    }

    @Nullable
    public JSONObject serializeToJson(@Nullable ActionEvent event) {
        if (event == null) {
            return null;
        }
        if (event instanceof PageViewEvent) {
            return this.serializeToJson((PageViewEvent)event);
        }
        if (event instanceof TapEvent) {
            return this.serializeToJson((TapEvent)event);
        }
        if (event instanceof DoubleTapEvent) {
            return this.serializeToJson((DoubleTapEvent)event);
        }
        if (event instanceof LongPressEvent) {
            return this.serializeToJson((LongPressEvent)event);
        }
        if (event instanceof DragEvent) {
            return this.serializeToJson((DragEvent)event);
        }
        if (event instanceof FlickEvent) {
            return this.serializeToJson((FlickEvent)event);
        }
        if (event instanceof CrashEvent) {
            return this.serializeToJson((CrashEvent)event);
        }
        if (event instanceof AppStartEvent) {
            return this.serializeToJson((AppStartEvent)event);
        }
        if (event instanceof AppShowEvent) {
            return this.serializeToJson((AppShowEvent)event);
        }
        if (event instanceof AppHideEvent) {
            return this.serializeToJson((AppHideEvent)event);
        }
        if (event instanceof AppExitEvent) {
            return this.serializeToJson((AppExitEvent)event);
        }
        if (BuildConfig.DEBUG) {
            this.mLog.e("!!Wrong event type sent! returning null.", new Object[0]);
        }
        return null;
    }
}

