/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model.data;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.util.Strings;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.UUID;
import org.json.JSONObject;

public abstract class ActionEvent {
    public static final int NO_EVENT = -1;
    public static final int APP_START = 0;
    public static final int APP_SHOW = 1;
    public static final int APP_HIDE = 2;
    public static final int APP_EXIT = 3;
    public static final int PAGE_VIEW = 4;
    public static final int SCREEN_ROTATE_RESIZE = 5;
    public static final int TAP = 6;
    public static final int DOUBLE_TAP = 7;
    public static final int LONG_PRESS = 8;
    public static final int DRAG = 9;
    public static final int FLICK = 10;
    public static final int PINCH = 11;
    public static final int KEYBOARD_EVENT = 12;
    public static final int INPUT = 13;
    public static final int INSTALL_REFERRAL = 14;
    public static final int CUSTOM_EVENT = 15;
    public static final int TRANSACTION = 16;
    public static final int CRASH = 17;
    public static final int LOW_MEMORY = 18;
    public static final int ORIENTATION_PORTRAIT = 0;
    public static final int ORIENTATION_LANDSCAPE = 1;
    public static final int FINGER_DIRECTION_NULL = 0;
    public static final int FINGER_DIRECTION_UP = 1;
    public static final int FINGER_DIRECTION_DOWN = 2;
    public static final int FINGER_DIRECTION_LEFT = 3;
    public static final int FINGER_DIRECTION_RIGHT = 4;
    public static final int FINGER_DIRECTION_COMPLEX_PATTERN = 5;
    public static final int CONNECTIVITY_ERROR = 0;
    public static final int OFFLINE = 1;
    public static final int WIFI = 2;
    public static final int EDGE = 3;
    public static final int HSPA = 4;
    public static final int LTE = 5;
    private static final int BATTERY_FULL = 100;
    private final String mUuid = UUID.randomUUID().toString();
    private final int mEventAction;
    @NonNull
    private final String mUrl;
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private final int mScreenCount;
    private final int mConnectionType;
    @NonNull
    private final String mCarrierId;
    @IntRange(from=0L, to=100L)
    private final int mBatteryLevel;
    private final boolean mBatteryCharging;
    private final int mOrientation;
    @NonNull
    private final JSONObject mOriginVersion;
    @IntRange(from=0L, to=0x7FFFFFFFL)
    private final int mSessionNumber;
    private final long mTimestamp;

    ActionEvent(Builder builder) {
        this.mEventAction = builder.getEventAction();
        this.mUrl = builder.getUrl();
        this.mScreenCount = builder.getScreenCount();
        this.mConnectionType = builder.getConnectionType();
        this.mCarrierId = builder.getCarrierId();
        this.mBatteryLevel = builder.getBatteryLevel();
        this.mBatteryCharging = builder.isBatteryCharging();
        this.mOrientation = builder.getOrientation();
        this.mOriginVersion = builder.getOriginVersion();
        this.mSessionNumber = builder.getSessionNumber();
        this.mTimestamp = builder.getTimestamp();
    }

    public String getUuid() {
        return this.mUuid;
    }

    public int getEventAction() {
        return this.mEventAction;
    }

    @NonNull
    public String getUrl() {
        return this.mUrl;
    }

    public int getScreenCount() {
        return this.mScreenCount;
    }

    public int getConnectionType() {
        return this.mConnectionType;
    }

    @NonNull
    public String getCarrierId() {
        return this.mCarrierId;
    }

    public int getBatteryLevel() {
        return this.mBatteryLevel;
    }

    public boolean isBatteryCharging() {
        return this.mBatteryCharging;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    @NonNull
    public JSONObject getOriginVersion() {
        return this.mOriginVersion;
    }

    public int getSessionNumber() {
        return this.mSessionNumber;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public static abstract class Builder<T extends ActionEvent> {
        private int mEventAction = 17;
        @NonNull
        private String mUrl = "";
        @IntRange(from=0L, to=0x7FFFFFFFL)
        private int mScreenCount = 0;
        private int mConnectionType = 0;
        @NonNull
        private String mCarrierId = "";
        @IntRange(from=0L, to=100L)
        private int mBatteryLevel;
        private boolean mBatteryCharging;
        private int mOrientation;
        @NonNull
        private JSONObject mOriginVersion = new JSONObject();
        @IntRange(from=0L, to=0x7FFFFFFFL)
        private int mSessionNumber;
        private long mTimestamp;

        Builder() {
            DeviceInfo deviceInfo = SingletonProvider.getAppComponent().getDeviceInfo();
            this.setBatteryLevel(deviceInfo.getBatteryLevelNow());
            this.setBatteryCharging(deviceInfo.isDeviceCharging());
            this.setCarrierId(deviceInfo.getCarrierName());
            this.setConnectionType(deviceInfo.getActiveConnectionType());
            this.setOrientation(deviceInfo.getScreenOrientation());
            this.setOriginVersion(deviceInfo.getVersionOrigin());
            Session session = SingletonProvider.getSessionComponent().getSession();
            this.setScreenCount(session.getScreenCount());
            this.setSessionNumber(session.getSessionId());
            this.setTimestamp(System.currentTimeMillis());
            String currentScreenUrl = session.getGlass().getCurrentScreenUrl();
            if (!Strings.isNullOrEmpty(currentScreenUrl)) {
                this.setUrl(currentScreenUrl);
            }
        }

        public int getEventAction() {
            return this.mEventAction;
        }

        public void setEventAction(int eventAction) {
            this.mEventAction = eventAction;
        }

        @Nullable
        public String getUrl() {
            return this.mUrl;
        }

        @NonNull
        public Builder setUrl(@NonNull String url) {
            this.mUrl = url;
            return this;
        }

        public int getScreenCount() {
            return this.mScreenCount;
        }

        @NonNull
        public Builder setScreenCount(int screenCount) {
            this.mScreenCount = screenCount;
            return this;
        }

        public int getConnectionType() {
            return this.mConnectionType;
        }

        @NonNull
        public Builder setConnectionType(int connectionType) {
            this.mConnectionType = connectionType;
            return this;
        }

        @NonNull
        public String getCarrierId() {
            return this.mCarrierId;
        }

        @NonNull
        public Builder setCarrierId(@NonNull String carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        @IntRange(from=0L, to=100L)
        public int getBatteryLevel() {
            return this.mBatteryLevel;
        }

        @NonNull
        public Builder setBatteryLevel(@IntRange(from=0L, to=100L) int batteryLevel) {
            this.mBatteryLevel = batteryLevel;
            return this;
        }

        public boolean isBatteryCharging() {
            return this.mBatteryCharging;
        }

        @NonNull
        public Builder setBatteryCharging(boolean batteryCharging) {
            this.mBatteryCharging = batteryCharging;
            return this;
        }

        public int getOrientation() {
            return this.mOrientation;
        }

        @NonNull
        public Builder setOrientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        @NonNull
        public JSONObject getOriginVersion() {
            return this.mOriginVersion;
        }

        @NonNull
        public Builder setOriginVersion(@NonNull JSONObject originVersion) {
            this.mOriginVersion = originVersion;
            return this;
        }

        public int getSessionNumber() {
            return this.mSessionNumber;
        }

        @NonNull
        public Builder setSessionNumber(@IntRange(from=0L, to=0x7FFFFFFFL) int sessionNumber) {
            this.mSessionNumber = sessionNumber;
            return this;
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        @NonNull
        public Builder setTimestamp(long timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        @NonNull
        public abstract T build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FingerDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FingerAction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventAction {
    }
}

