/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import com.contentsquare.android.internal.model.data.ActionEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CrashEvent
extends ActionEvent {
    public static final int CRASH_UNKNOWN = 0;
    public static final int CRASH_SDK = 1;
    public static final int CRASH_APP = 2;
    private final String mMessage;
    private final int mCrashOrigin;
    private final boolean mFatal;

    private CrashEvent(CrashEventBuilder builder) {
        super(builder);
        this.mMessage = builder.getMessage();
        this.mCrashOrigin = builder.getCrashOrigin();
        this.mFatal = builder.isFatal();
    }

    public String getMessage() {
        return this.mMessage;
    }

    public int getCrashOrigin() {
        return this.mCrashOrigin;
    }

    public boolean isFatal() {
        return this.mFatal;
    }

    public static class CrashEventBuilder
    extends ActionEvent.Builder<CrashEvent> {
        private String mMessage;
        private int mCrashOrigin;
        private boolean mFatal;

        public CrashEventBuilder() {
            this.setEventAction(17);
        }

        public boolean isFatal() {
            return this.mFatal;
        }

        public void setFatal(boolean fatal) {
            this.mFatal = fatal;
        }

        public String getMessage() {
            return this.mMessage;
        }

        public CrashEventBuilder setMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public int getCrashOrigin() {
            return this.mCrashOrigin;
        }

        public CrashEventBuilder setCrashOrigin(int crashOrigin) {
            this.mCrashOrigin = crashOrigin;
            return this;
        }

        @Override
        @NonNull
        public CrashEvent build() {
            return new CrashEvent(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CrashOrigin {
    }
}

