/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.contentsquare.android.internal.model.data.ActionEvent;

public final class DragEvent
extends ActionEvent {
    @NonNull
    private final String mTouchPath;
    @Nullable
    private final String mViewLabel;
    @Nullable
    private final String mViewId;
    @Nullable
    private final String mViewAccessibilityLabel;
    private final int mFingerDirection;
    private final int mTargetViewDistanceDragged;
    private final int mTargetViewVelocity;

    public DragEvent(DragEventBuilder builder) {
        super(builder);
        this.mTouchPath = builder.getTouchPath();
        this.mViewId = builder.getViewId();
        this.mViewLabel = builder.getViewLabel();
        this.mViewAccessibilityLabel = builder.getViewAccessibilityLabel();
        this.mFingerDirection = builder.getFingerDirection();
        this.mTargetViewDistanceDragged = builder.getTargetViewDistanceDragged();
        this.mTargetViewVelocity = builder.getTargetViewVelocity();
    }

    @NonNull
    public String getTouchPath() {
        return this.mTouchPath;
    }

    @Nullable
    public String getViewLabel() {
        return this.mViewLabel;
    }

    @Nullable
    public String getViewId() {
        return this.mViewId;
    }

    @Nullable
    public String getViewAccessibilityLabel() {
        return this.mViewAccessibilityLabel;
    }

    public int getFingerDirection() {
        return this.mFingerDirection;
    }

    public int getTargetViewDistanceDragged() {
        return this.mTargetViewDistanceDragged;
    }

    public int getTargetViewVelocity() {
        return this.mTargetViewVelocity;
    }

    public static class DragEventBuilder
    extends ActionEvent.Builder<DragEvent> {
        @NonNull
        private String mTouchPath;
        @Nullable
        private String mViewLabel;
        @Nullable
        private String mViewId;
        @Nullable
        private String mViewAccessibilityLabel;
        private int mFingerDirection;
        private int mTargetViewDistanceDragged;
        private int mTargetViewVelocity;

        public DragEventBuilder() {
            this.setEventAction(9);
        }

        @NonNull
        public String getTouchPath() {
            return this.mTouchPath;
        }

        @NonNull
        public DragEventBuilder setTouchPath(@NonNull String touchPath) {
            this.mTouchPath = touchPath;
            return this;
        }

        @Nullable
        public String getViewLabel() {
            return this.mViewLabel;
        }

        @NonNull
        public DragEventBuilder setViewLabel(@Nullable String viewLabel) {
            this.mViewLabel = viewLabel;
            return this;
        }

        @Nullable
        public String getViewId() {
            return this.mViewId;
        }

        @NonNull
        public DragEventBuilder setViewId(@Nullable String viewId) {
            this.mViewId = viewId;
            return this;
        }

        @Nullable
        public String getViewAccessibilityLabel() {
            return this.mViewAccessibilityLabel;
        }

        @NonNull
        public DragEventBuilder setViewAccessibilityLabel(@Nullable String viewAccessibilityLabel) {
            this.mViewAccessibilityLabel = viewAccessibilityLabel;
            return this;
        }

        public int getFingerDirection() {
            return this.mFingerDirection;
        }

        @NonNull
        public DragEventBuilder setFingerDirection(int fingerDirection) {
            this.mFingerDirection = fingerDirection;
            return this;
        }

        public int getTargetViewDistanceDragged() {
            return this.mTargetViewDistanceDragged;
        }

        @NonNull
        public DragEventBuilder setTargetViewDistanceDragged(int targetViewDistanceDragged) {
            this.mTargetViewDistanceDragged = targetViewDistanceDragged;
            return this;
        }

        public int getTargetViewVelocity() {
            return this.mTargetViewVelocity;
        }

        @NonNull
        public DragEventBuilder setTargetViewVelocity(int targetViewVelocity) {
            this.mTargetViewVelocity = targetViewVelocity;
            return this;
        }

        @Override
        @NonNull
        public DragEvent build() {
            return new DragEvent(this);
        }
    }
}

