/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class EventsBundle {
    private final String mUserId;
    private final int mProjectId;
    private final int mDeviceType;
    private final String mOsName;
    private final String mDeviceLanguage;
    private final boolean mAnonimizerEnabled;
    private final String mTimezone;
    private final JSONObject mTypeOrigin;
    private final JSONObject mDeviceResolution;
    private final JSONArray mPayload;

    private EventsBundle(@NonNull BundleBuilder bundleBuilder) {
        this.mUserId = bundleBuilder.getUserId();
        this.mProjectId = bundleBuilder.getProjectId();
        this.mDeviceType = bundleBuilder.getDeviceType();
        this.mOsName = bundleBuilder.getOsName();
        this.mDeviceLanguage = bundleBuilder.getDeviceLanguage();
        this.mAnonimizerEnabled = bundleBuilder.isAnonymizerEnabled();
        this.mTimezone = bundleBuilder.getTimezone();
        this.mTypeOrigin = bundleBuilder.getTypeOrigin();
        this.mDeviceResolution = bundleBuilder.getDeviceResolution();
        this.mPayload = bundleBuilder.getPayload();
    }

    public String getUserId() {
        return this.mUserId;
    }

    public int getProjectId() {
        return this.mProjectId;
    }

    public int getDeviceType() {
        return this.mDeviceType;
    }

    public String getOsName() {
        return this.mOsName;
    }

    public String getDeviceLanguage() {
        return this.mDeviceLanguage;
    }

    public boolean isAnonymizerEnabled() {
        return this.mAnonimizerEnabled;
    }

    public String getTimezone() {
        return this.mTimezone;
    }

    public JSONObject getTypeOrigin() {
        return this.mTypeOrigin;
    }

    public JSONObject getDeviceResolution() {
        return this.mDeviceResolution;
    }

    public JSONArray getPayload() {
        return this.mPayload;
    }

    public static final class BundleBuilder {
        private final String mUserId;
        private final int mProjectId;
        private final int mDeviceType;
        private final String mOsName;
        private final String mDeviceLanguage;
        private final boolean mAnonymizerEnabled;
        private final String mTimezone;
        private final JSONObject mTypeOrigin;
        private final JSONObject mDeviceResolution;
        private final JSONArray mPayload;

        public BundleBuilder() {
            Session session = SingletonProvider.getSessionComponent().getSession();
            this.mUserId = session.getUserId();
            this.mProjectId = session.getRunConfiguration().getCsProjectId();
            this.mAnonymizerEnabled = session.getRunConfiguration().isAnonymousEnabled();
            DeviceInfo deviceInfo = SingletonProvider.getAppComponent().getDeviceInfo();
            this.mDeviceType = deviceInfo.getDeviceIntType();
            this.mOsName = deviceInfo.getDeviceOs();
            this.mDeviceLanguage = deviceInfo.getUserLanguage();
            this.mTimezone = deviceInfo.getUserTimezone();
            this.mTypeOrigin = deviceInfo.getTypeOrigin();
            this.mDeviceResolution = deviceInfo.getDeviceResolutionJson();
            this.mPayload = new JSONArray();
        }

        public String getUserId() {
            return this.mUserId;
        }

        public int getProjectId() {
            return this.mProjectId;
        }

        public int getDeviceType() {
            return this.mDeviceType;
        }

        public String getOsName() {
            return this.mOsName;
        }

        public String getDeviceLanguage() {
            return this.mDeviceLanguage;
        }

        public boolean isAnonymizerEnabled() {
            return this.mAnonymizerEnabled;
        }

        public String getTimezone() {
            return this.mTimezone;
        }

        public JSONObject getTypeOrigin() {
            return this.mTypeOrigin;
        }

        public JSONObject getDeviceResolution() {
            return this.mDeviceResolution;
        }

        public JSONArray getPayload() {
            return this.mPayload;
        }

        @NonNull
        public BundleBuilder setPayload(List<JSONObject> payload) {
            for (JSONObject json : payload) {
                this.mPayload.put((Object)json);
            }
            return this;
        }

        public EventsBundle build() {
            return new EventsBundle(this);
        }
    }
}

