/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.contentsquare.android.internal.model.data.ActionEvent;

public final class FlickEvent
extends ActionEvent {
    @NonNull
    private final String mTouchPath;
    @Nullable
    private final String mViewLabel;
    @Nullable
    private final String mViewId;
    @Nullable
    private final String mViewAccessibilityLabel;
    private final int mFingerDirection;
    private final int mTargetViewDistanceDragged;
    private final int mTargetViewVelocity;

    private FlickEvent(FlickEventBuilder builder) {
        super(builder);
        this.mTouchPath = builder.getTouchPath();
        this.mViewId = builder.getViewId();
        this.mViewLabel = builder.getViewLabel();
        this.mViewAccessibilityLabel = builder.getViewAccessibilityLabel();
        this.mFingerDirection = builder.getFingerDirection();
        this.mTargetViewDistanceDragged = builder.getTargetViewDistanceDragged();
        this.mTargetViewVelocity = builder.getTargetViewVelocity();
    }

    @NonNull
    public String getTouchPath() {
        return this.mTouchPath;
    }

    @Nullable
    public String getViewLabel() {
        return this.mViewLabel;
    }

    @Nullable
    public String getViewId() {
        return this.mViewId;
    }

    @Nullable
    public String getViewAccessibilityLabel() {
        return this.mViewAccessibilityLabel;
    }

    public int getFingerDirection() {
        return this.mFingerDirection;
    }

    public int getTargetViewDistanceDragged() {
        return this.mTargetViewDistanceDragged;
    }

    public int getTargetViewVelocity() {
        return this.mTargetViewVelocity;
    }

    public static class FlickEventBuilder
    extends ActionEvent.Builder<FlickEvent> {
        @NonNull
        private String mTouchPath;
        @Nullable
        private String mViewLabel;
        @Nullable
        private String mViewId;
        @Nullable
        private String mViewAccessibilItyLabel;
        private int mFingerDirection;
        private int mTargetViewDistanceDragged;
        private int mTargetViewVelocity;

        public FlickEventBuilder() {
            this.setEventAction(10);
        }

        @NonNull
        public String getTouchPath() {
            return this.mTouchPath;
        }

        @NonNull
        public FlickEventBuilder setTouchPath(@NonNull String touchPath) {
            this.mTouchPath = touchPath;
            return this;
        }

        @Nullable
        public String getViewLabel() {
            return this.mViewLabel;
        }

        @NonNull
        public FlickEventBuilder setViewLabel(@Nullable String viewLabel) {
            this.mViewLabel = viewLabel;
            return this;
        }

        @Nullable
        public String getViewId() {
            return this.mViewId;
        }

        @NonNull
        public FlickEventBuilder setViewId(@Nullable String viewId) {
            this.mViewId = viewId;
            return this;
        }

        @Nullable
        public String getViewAccessibilityLabel() {
            return this.mViewAccessibilItyLabel;
        }

        @NonNull
        public FlickEventBuilder setViewAccessibilityLabel(@Nullable String viewAccessibiltyLabel) {
            this.mViewAccessibilItyLabel = viewAccessibiltyLabel;
            return this;
        }

        public int getFingerDirection() {
            return this.mFingerDirection;
        }

        public FlickEventBuilder setFingerDirection(int fingerDirection) {
            this.mFingerDirection = fingerDirection;
            return this;
        }

        public int getTargetViewDistanceDragged() {
            return this.mTargetViewDistanceDragged;
        }

        public FlickEventBuilder setTargetViewDistanceDragged(int targetViewDistanceDragged) {
            this.mTargetViewDistanceDragged = targetViewDistanceDragged;
            return this;
        }

        public int getTargetViewVelocity() {
            return this.mTargetViewVelocity;
        }

        public FlickEventBuilder setTargetViewVelocity(int targetViewVelocity) {
            this.mTargetViewVelocity = targetViewVelocity;
            return this;
        }

        @Override
        @NonNull
        public FlickEvent build() {
            return new FlickEvent(this);
        }
    }
}

