/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.model.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.contentsquare.android.internal.model.data.ActionEvent;

public final class TapEvent
extends ActionEvent {
    @NonNull
    private final String mTouchPath;
    @Nullable
    private final String mViewLabel;
    @Nullable
    private final String mViewId;
    @Nullable
    private final String mViewAccessibilityLabel;
    @Nullable
    private final boolean mTouchUnresponsive;

    private TapEvent(TapEventBuilder builder) {
        super(builder);
        this.mTouchPath = builder.getTouchPath();
        this.mViewId = builder.getViewId();
        this.mViewLabel = builder.getViewLabel();
        this.mViewAccessibilityLabel = builder.getViewAccessibiltyLabel();
        this.mTouchUnresponsive = builder.isTouchUnresponsive();
    }

    @NonNull
    public String getTouchPath() {
        return this.mTouchPath;
    }

    @Nullable
    public String getViewLabel() {
        return this.mViewLabel;
    }

    @Nullable
    public String getViewId() {
        return this.mViewId;
    }

    @Nullable
    public String getViewAccessibilityLabel() {
        return this.mViewAccessibilityLabel;
    }

    public boolean isTouchUnresponsive() {
        return this.mTouchUnresponsive;
    }

    public static class TapEventBuilder
    extends ActionEvent.Builder<TapEvent> {
        @NonNull
        private String mTouchPath;
        @Nullable
        private String mViewLabel;
        @Nullable
        private String mViewId;
        @Nullable
        private String mViewAccessibiltyLabel;
        private boolean mTouchUnresponsive;

        public TapEventBuilder() {
            this.setEventAction(6);
        }

        @NonNull
        public String getTouchPath() {
            return this.mTouchPath;
        }

        @NonNull
        public TapEventBuilder setTouchPath(@NonNull String touchPath) {
            this.mTouchPath = touchPath;
            return this;
        }

        @Nullable
        public String getViewLabel() {
            return this.mViewLabel;
        }

        @NonNull
        public TapEventBuilder setViewLabel(@Nullable String viewLabel) {
            this.mViewLabel = viewLabel;
            return this;
        }

        @Nullable
        public String getViewId() {
            return this.mViewId;
        }

        @NonNull
        public TapEventBuilder setViewId(@Nullable String viewId) {
            this.mViewId = viewId;
            return this;
        }

        @Nullable
        public String getViewAccessibiltyLabel() {
            return this.mViewAccessibiltyLabel;
        }

        @NonNull
        public TapEventBuilder setViewAccessibilityLabel(@Nullable String viewAccessibiltyLabel) {
            this.mViewAccessibiltyLabel = viewAccessibiltyLabel;
            return this;
        }

        public boolean isTouchUnresponsive() {
            return this.mTouchUnresponsive;
        }

        public TapEventBuilder setTouchUnresponsive(boolean touchUnresponsive) {
            this.mTouchUnresponsive = touchUnresponsive;
            return this;
        }

        @Override
        @NonNull
        public TapEvent build() {
            return new TapEvent(this);
        }
    }
}

