/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.network;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.async.ThreadExecutor;
import com.contentsquare.android.internal.async.TransactionRunnable;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.HttpConnection;
import javax.inject.Inject;
import org.json.JSONObject;

public class NetworkTransaction {
    @Inject
    ThreadExecutor mExecutor;
    private final Logger mLogger = new Logger("NetworkTransaction");

    public NetworkTransaction() {
        SingletonProvider.getSessionComponent().inject(this);
    }

    public void scheduleSend(final @NonNull JSONObject json, final @NonNull String endpoint, final @NonNull NetworkTransactionListener listener) {
        TransactionRunnable runnable = new TransactionRunnable(){

            @Override
            public void rollBack() {
                listener.fail();
            }

            @Override
            public void run() {
                HttpConnection.HttpResponse result = NetworkTransaction.this.getHttpConnection().performPostWithJson(endpoint, json);
                if (result.positive()) {
                    NetworkTransaction.this.mLogger.i("Sending json to URL: %s", endpoint);
                    listener.pass();
                    return;
                }
                NetworkTransaction.this.mLogger.i("Failed to send json to URL: %s", endpoint);
                listener.fail();
            }
        };
        boolean dispatchSuccessful = this.mExecutor.dispatch(runnable);
        if (!dispatchSuccessful) {
            this.mLogger.w("dispatch not successful, failing!", new Object[0]);
            listener.fail();
        } else {
            this.mLogger.w("dispatch success, should exec soon!", new Object[0]);
        }
    }

    @VisibleForTesting
    HttpConnection getHttpConnection() {
        return new HttpConnection();
    }

    public static interface NetworkTransactionListener {
        public void pass();

        public void fail();
    }
}

