/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.util.MD5Hash;
import com.contentsquare.android.internal.util.Strings;

public class PrefsHelper {
    private static final String CS_PREFS_NAME = "cs";
    public static final String LAST_SEGMENT = "last_segment";
    public static final String TRACKABLE = "trackable";
    @VisibleForTesting
    final SharedPreferences mSharedPreferences;

    public PrefsHelper(@NonNull Context context) {
        this.mSharedPreferences = context.getSharedPreferences(CS_PREFS_NAME, 0);
    }

    public boolean containsProperty(@NonNull String label) {
        return !Strings.isNullOrEmpty(label) && this.mSharedPreferences.contains(this.getHashedLabel(label));
    }

    public void putBoolean(@NonNull String label, boolean value) {
        if (Strings.isNullOrEmpty(label)) {
            return;
        }
        SharedPreferences.Editor edit = this.mSharedPreferences.edit();
        edit.putBoolean(this.getHashedLabel(label), value);
        edit.apply();
    }

    public boolean getBoolean(@NonNull String label, boolean defaultValue) {
        if (Strings.isNullOrEmpty(label)) {
            return defaultValue;
        }
        return this.mSharedPreferences.getBoolean(this.getHashedLabel(label), defaultValue);
    }

    public void putInt(@NonNull String label, int value) {
        if (Strings.isNullOrEmpty(label)) {
            return;
        }
        SharedPreferences.Editor edit = this.mSharedPreferences.edit();
        edit.putInt(this.getHashedLabel(label), value);
        edit.apply();
    }

    public int getInt(@NonNull String label, int defaultValue) {
        if (Strings.isNullOrEmpty(label)) {
            return defaultValue;
        }
        return this.mSharedPreferences.getInt(this.getHashedLabel(label), defaultValue);
    }

    public void putFloat(@NonNull String label, float value) {
        if (Strings.isNullOrEmpty(label)) {
            return;
        }
        SharedPreferences.Editor edit = this.mSharedPreferences.edit();
        edit.putFloat(this.getHashedLabel(label), value);
        edit.apply();
    }

    public float getFloat(@NonNull String label, float defaultValue) {
        if (Strings.isNullOrEmpty(label)) {
            return defaultValue;
        }
        return this.mSharedPreferences.getFloat(this.getHashedLabel(label), defaultValue);
    }

    public void putString(@NonNull String label, @Nullable String value) {
        if (Strings.isNullOrEmpty(label)) {
            return;
        }
        SharedPreferences.Editor edit = this.mSharedPreferences.edit();
        edit.putString(this.getHashedLabel(label), value);
        edit.apply();
    }

    @Nullable
    public String getString(@NonNull String label, @Nullable String defaultValue) {
        if (Strings.isNullOrEmpty(label)) {
            return defaultValue;
        }
        return this.mSharedPreferences.getString(this.getHashedLabel(label), defaultValue);
    }

    public void deleteAndResetAll() {
        SharedPreferences.Editor edit = this.mSharedPreferences.edit();
        edit.clear();
        edit.apply();
    }

    @Nullable
    private String getHashedLabel(String label) {
        return new MD5Hash(label).getMd5Hash();
    }
}

