/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screengraph;

import android.support.annotation.Nullable;
import com.contentsquare.android.internal.util.ViewUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonView {
    private static final String ID = "id";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String CHILDREN = "views";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String BITMAP = "bmp";
    private static final String BACKGROUND = "bg";
    private static final String METADATA = "metadata";
    private static final String VISIBILITY = "visibility";
    private String mId;
    private int mWidth;
    private int mHeight;
    private int mPosX;
    private int mPosY;
    private JSONObject mMetadata;
    private List<JsonView> mChildren;
    private byte[] mBitmap;
    private String mBackground;
    private boolean mVisible;
    private final ViewUtil mViewUtil;

    public JsonView(ViewUtil viewUtil) {
        this.mViewUtil = viewUtil;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id2) {
        this.mId = id2;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public List<JsonView> getChildren() {
        return this.mChildren;
    }

    public void setChildren(List<JsonView> children) {
        this.mChildren = children;
    }

    int getPosX() {
        return this.mPosX;
    }

    public void setPosX(int posX) {
        this.mPosX = posX;
    }

    int getPosY() {
        return this.mPosY;
    }

    public void setPosY(int posY) {
        this.mPosY = posY;
    }

    JSONObject getMetadata() {
        return this.mMetadata;
    }

    public void setMetadata(JSONObject metadata) {
        this.mMetadata = metadata;
    }

    @Nullable
    public String getBackground() {
        return this.mBackground;
    }

    public void setBackground(String background) {
        this.mBackground = background;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    @Nullable
    public byte[] getBitmap() {
        return this.mBitmap;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setBitmap(byte[] bitmap) {
        this.mBitmap = bitmap;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    @Nullable
    JSONObject toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        jsonObject.put(ID, (Object)this.getId());
        jsonObject.put(HEIGHT, this.getHeight());
        jsonObject.put(WIDTH, this.getWidth());
        jsonObject.put(X, this.getPosX());
        jsonObject.put(Y, this.getPosY());
        if (this.mBitmap != null) {
            jsonObject.put(BITMAP, (Object)this.mViewUtil.encodeImage(this.mBitmap));
        }
        if (this.mBackground != null) {
            jsonObject.put(BACKGROUND, (Object)this.mBackground);
        }
        jsonObject.put(VISIBILITY, this.isVisible());
        jsonObject.put(METADATA, (Object)this.getMetadata());
        if (this.getChildren() != null) {
            for (JsonView obj : this.getChildren()) {
                jsonArray.put((Object)obj.toJson());
            }
            jsonObject.put(CHILDREN, (Object)jsonArray);
        }
        return jsonObject;
    }
}

