/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screengraph;

import android.app.ActionBar;
import android.app.Activity;
import android.app.Application;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.ResourceUtils;
import com.contentsquare.android.internal.util.ViewUtil;

public class PathGenerator {
    public static final String SCREEN_TITLE_KEY = "title";
    private static final String PROTOCOL = "app-and://";
    @NonNull
    private final Application mApplication;
    @NonNull
    private final ViewUtil mViewUtil;
    private final Logger mLogger = new Logger("PathGenerator");

    public PathGenerator(@NonNull Application application, @NonNull ViewUtil viewUtil) {
        this.mApplication = application;
        this.mViewUtil = viewUtil;
    }

    @NonNull
    public String generateUrl(@NonNull Activity activity, @NonNull ViewGroup rootView) {
        Uri rootUri = this.getRootUri();
        String url = this.getPagePath(rootUri, rootView, activity);
        this.mLogger.d("Complete Path: %s", url);
        return url;
    }

    @NonNull
    public String generateUrl(@NonNull Activity activity, @NonNull Fragment fragment, @Nullable ViewGroup viewGroup) {
        Uri rootUri = this.getRootUri();
        return this.getSubPagePath(rootUri, activity, fragment, viewGroup);
    }

    @NonNull
    private String getPagePath(@NonNull Uri root, @NonNull ViewGroup rootView, @NonNull Activity activity) {
        String pagePath = activity.getClass().getSimpleName().replace("Activity", "");
        View biggestView = this.mViewUtil.getBiggestViewInHierarchy(rootView);
        String viewPath = ResourceUtils.getResourceEntryName(biggestView, "id_" + biggestView.getClass().getSimpleName());
        Uri.Builder ub = root.buildUpon();
        ub.appendPath(pagePath).appendPath(viewPath);
        this.addQueryParams(ub, activity);
        return ub.toString();
    }

    @NonNull
    private String getSubPagePath(@NonNull Uri root, @NonNull Activity activity, @NonNull Fragment fragment, @Nullable ViewGroup rootView) {
        String pagePath = activity.getClass().getSimpleName().replace("Activity", "");
        String subPagePath = fragment.getClass().getSimpleName().replace("Fragment", "");
        Uri.Builder ub = root.buildUpon();
        if (rootView != null) {
            View biggestView = this.mViewUtil.getBiggestViewInHierarchy(rootView);
            String viewPath = ResourceUtils.getResourceEntryName(biggestView, "id_" + biggestView.getClass().getSimpleName());
            ub.appendPath(pagePath).appendPath(subPagePath + "_" + viewPath);
            this.addQueryParams(ub, activity);
        } else {
            ub.appendPath(pagePath).appendPath(subPagePath);
            this.addQueryParams(ub, activity);
        }
        return ub.toString();
    }

    private void addQueryParams(@NonNull Uri.Builder ub, @NonNull Activity activity) {
        CharSequence title = this.getActivityTitle(activity);
        if (title != null && title.length() > 0) {
            ub.appendQueryParameter(SCREEN_TITLE_KEY, String.valueOf(title));
        }
    }

    @Nullable
    private CharSequence getActivityTitle(@NonNull Activity activity) {
        android.support.v7.app.ActionBar supportActionBar;
        CharSequence title = null;
        ActionBar actionBar = activity.getActionBar();
        if (actionBar != null) {
            title = actionBar.getTitle();
        }
        if (activity instanceof AppCompatActivity && (supportActionBar = ((AppCompatActivity)activity).getSupportActionBar()) != null) {
            title = supportActionBar.getTitle();
        }
        if (title == null || title.length() <= 0) {
            title = activity.getTitle();
        }
        return title;
    }

    @NonNull
    private Uri getRootUri() {
        String appId = this.mApplication.getPackageName();
        return Uri.parse((String)(PROTOCOL + appId));
    }
}

