/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screengraph;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.ViewGroup;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.screengraph.Screen;
import com.contentsquare.android.internal.screengraph.TreeTraverser;
import org.json.JSONException;
import org.json.JSONObject;

public class Screengraph {
    @Nullable
    public JSONObject obtain(@NonNull ViewGroup rootView, @Nullable String url, int hashId) {
        Logger logger = new Logger("Screengraph");
        Screen graph = this.getTraverser().traverse(rootView, url, hashId);
        try {
            logger.d("Obtaining graph from %s", rootView.toString());
            return graph.toJson();
        }
        catch (JSONException e) {
            logger.w(e, "Failed to Serialized Scenegraph to JSON", new Object[0]);
            return null;
        }
    }

    @VisibleForTesting
    @NonNull
    TreeTraverser getTraverser() {
        return new TreeTraverser();
    }
}

