/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screengraph;

import android.app.Application;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.ViewGroup;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.screengraph.JsonView;
import com.contentsquare.android.internal.screengraph.Screen;
import com.contentsquare.android.internal.ui.glasspane.GlassPaneLayout;
import com.contentsquare.android.internal.util.ResourceUtils;
import com.contentsquare.android.internal.util.ViewUtil;
import java.util.ArrayList;
import javax.inject.Inject;

public class TreeTraverser {
    public static final String CS_GLASS = "cs_glass_pane";
    public static final String CS_GLASS_TOP = "cs_glass_pane_top";
    public static final String CS_LAYOUT_NAME = "GlassPaneLayout";
    public static final String CS_GLASS_CONTAINER = "glass_pane";
    private static final String GRAPH_VERSION = "1";
    @Inject
    DeviceInfo mDeviceInfo;
    @Inject
    Application mApplication;
    @Inject
    ViewUtil mViewUtil;

    TreeTraverser() {
        SingletonProvider.getSessionComponent().inject(this);
    }

    @NonNull
    Screen traverse(@NonNull ViewGroup view, @Nullable String url, int hashId) {
        Screen screenTreeGraph = new Screen();
        screenTreeGraph.setHeight(this.mDeviceInfo.getDeviceResolution().get("h"));
        screenTreeGraph.setWidth(this.mDeviceInfo.getDeviceResolution().get("w"));
        screenTreeGraph.setVersion(this.mDeviceInfo.getSdkVersion());
        screenTreeGraph.setVersionJson(GRAPH_VERSION);
        screenTreeGraph.setHashId(hashId);
        screenTreeGraph.setVersionApp(this.mDeviceInfo.getApplicationVersion());
        ArrayList<JsonView> listChild = new ArrayList<JsonView>();
        listChild.add(this.traverseView(view));
        screenTreeGraph.setChildren(listChild);
        screenTreeGraph.setUrl(url);
        return screenTreeGraph;
    }

    @VisibleForTesting
    JsonView traverseView(ViewGroup view) {
        if (view instanceof GlassPaneLayout) {
            return this.traverseView((ViewGroup)view.getChildAt(0));
        }
        JsonView viewObj = this.mViewUtil.toObject((View)view);
        ArrayList<JsonView> listChildrenView = new ArrayList<JsonView>();
        int childCount = view.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = view.getChildAt(i);
            String childResource = ResourceUtils.getResourceEntryName(child, "null");
            if (childResource.startsWith(CS_GLASS_TOP)) continue;
            if (child instanceof ViewGroup) {
                listChildrenView.add(this.traverseView((ViewGroup)child));
                continue;
            }
            listChildrenView.add(this.mViewUtil.toObject(child));
        }
        viewObj.setChildren(listChildrenView);
        return viewObj;
    }
}

