/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screenmonitoring;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.contentsquare.android.internal.logging.Logger;

class ActivityValidator {
    public static final String TAG = "ActivityValidator";
    @NonNull
    private final Logger mLogger;

    ActivityValidator(@NonNull Logger logger) {
        this.mLogger = logger;
    }

    boolean isValidFragmentActivity(@NonNull Activity activity) {
        if (FragmentActivity.class.isAssignableFrom(activity.getClass())) {
            try {
                String classNameToCheck = "android.support.v4.app.FragmentManager$FragmentLifecycleCallbacks";
                this.checkClassForName("android.support.v4.app.FragmentManager$FragmentLifecycleCallbacks");
                FragmentManager supportFragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
                this.checkMethodOnFragmentManager(supportFragmentManager);
                return true;
            }
            catch (ClassNotFoundException e) {
                this.mLogger.w("Could not attach to Activity due to wrong Support API version.", e);
            }
            catch (NoSuchMethodException e1) {
                this.mLogger.w("Could not attach to Activity due to wrong Support API version.", e1);
            }
        }
        return false;
    }

    @VisibleForTesting
    Class<?> checkClassForName(@NonNull String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    @VisibleForTesting
    void checkMethodOnFragmentManager(@NonNull FragmentManager manager) throws NoSuchMethodException {
        manager.getClass().getDeclaredMethod("registerFragmentLifecycleCallbacks", FragmentManager.FragmentLifecycleCallbacks.class, Boolean.TYPE);
    }
}

