/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screenmonitoring;

import android.app.Activity;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.screenmonitoring.ActivityValidator;
import com.contentsquare.android.internal.screenmonitoring.IScreenChangedCallback;
import com.contentsquare.android.internal.screenmonitoring.IScreenMonitoringService;
import com.contentsquare.android.internal.screenmonitoring.StrategiesCache;
import com.contentsquare.android.internal.screenmonitoring.strategies.IActivityMonitoringStrategy;
import com.contentsquare.android.internal.util.DateTimeUtil;
import java.util.Map;

public class ScreenMonitoringService
implements IScreenMonitoringService {
    public static final String TAG = "ScreenMonitoringService";
    @NonNull
    private final StrategiesCache mStrategiesCache;

    ScreenMonitoringService(@NonNull ActivityValidator activityValidator, @NonNull DateTimeUtil dateTimeUtil) {
        this.mStrategiesCache = new StrategiesCache(activityValidator, dateTimeUtil);
    }

    ScreenMonitoringService() {
        this(new ActivityValidator(new Logger("ActivityValidator")), SingletonProvider.getAppComponent().getDateTimeUtil());
    }

    @Override
    @CheckResult
    public boolean attachTo(@NonNull Activity activity, IScreenChangedCallback callback) {
        IActivityMonitoringStrategy strategy = this.mStrategiesCache.get(activity);
        return strategy.attachTo(activity, callback);
    }

    @Override
    public void detachFrom(@NonNull Activity activity) {
        IActivityMonitoringStrategy strategy = this.mStrategiesCache.getFromCache(activity);
        if (strategy != null) {
            strategy.detachFrom(activity);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @NonNull
    Map<Class<?>, IActivityMonitoringStrategy> strategies() {
        return this.mStrategiesCache.strategies();
    }
}

