/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screenmonitoring;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArrayMap;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.screenmonitoring.ActivityValidator;
import com.contentsquare.android.internal.screenmonitoring.strategies.DummyStrategy;
import com.contentsquare.android.internal.screenmonitoring.strategies.FragmentActivityMonitoringStrategy;
import com.contentsquare.android.internal.screenmonitoring.strategies.IActivityMonitoringStrategy;
import com.contentsquare.android.internal.util.DateTimeUtil;
import java.util.Collections;
import java.util.Map;

class StrategiesCache {
    private static final String TAG = "StrategiesCache";
    private final ArrayMap<Class<?>, IActivityMonitoringStrategy> mStrategies = new ArrayMap();
    @NonNull
    private final ActivityValidator mActivityValidator;
    @NonNull
    private final Logger mLogger = new Logger("StrategiesCache");
    @NonNull
    private final DateTimeUtil mDateTimeUtils;

    StrategiesCache(@NonNull ActivityValidator activityValidator, @NonNull DateTimeUtil dateTimeUtils) {
        this.mActivityValidator = activityValidator;
        this.mDateTimeUtils = dateTimeUtils;
    }

    IActivityMonitoringStrategy get(@NonNull Activity activity) {
        return this.determineAndProvideStrategy(activity);
    }

    @Nullable
    IActivityMonitoringStrategy getFromCache(@NonNull Activity activity) {
        return (IActivityMonitoringStrategy)this.mStrategies.get(activity.getClass());
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    Map<Class<?>, IActivityMonitoringStrategy> strategies() {
        return Collections.unmodifiableMap(this.mStrategies);
    }

    @NonNull
    private IActivityMonitoringStrategy determineAndProvideStrategy(@NonNull Activity activity) {
        if (this.mActivityValidator.isValidFragmentActivity(activity)) {
            IActivityMonitoringStrategy strategy = (IActivityMonitoringStrategy)this.mStrategies.get(activity.getClass());
            if (strategy == null) {
                strategy = new FragmentActivityMonitoringStrategy(this.mDateTimeUtils);
                this.mStrategies.put(activity.getClass(), (Object)strategy);
            }
            this.mLogger.d("[ DetermineAndProvideStrategy ]: Strategy found for the FragmentActivity with the right Support API.", new Object[0]);
            return strategy;
        }
        return new DummyStrategy();
    }
}

