/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.screenmonitoring.strategies;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.SparseArrayCompat;
import com.contentsquare.android.internal.screenmonitoring.IScreenChangedCallback;
import com.contentsquare.android.internal.screenmonitoring.strategies.IActivityMonitoringStrategy;
import com.contentsquare.android.internal.util.DateTimeUtil;
import com.contentsquare.android.internal.util.MathUtil;
import java.util.Map;

public class FragmentActivityMonitoringStrategy
implements IActivityMonitoringStrategy {
    private final Map<Activity, ScreenChangedCallbackWrapper> mCallbacks = new ArrayMap();
    @NonNull
    private final DateTimeUtil mDateTimeUtils;

    public FragmentActivityMonitoringStrategy(@NonNull DateTimeUtil dateTimeUtil) {
        this.mDateTimeUtils = dateTimeUtil;
    }

    @Override
    public boolean attachTo(@NonNull Activity activity, @NonNull IScreenChangedCallback callback) {
        if (!(activity instanceof FragmentActivity)) {
            return false;
        }
        ScreenChangedCallbackWrapper callbackWrapper = new ScreenChangedCallbackWrapper(this.mDateTimeUtils, callback);
        this.mCallbacks.put(activity, callbackWrapper);
        ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)callbackWrapper, true);
        return true;
    }

    @Override
    public void detachFrom(@NonNull Activity activity) {
        ((FragmentActivity)activity).getSupportFragmentManager().unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.mCallbacks.remove(activity));
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @Nullable
    public IScreenChangedCallback callback(@NonNull Activity activity) {
        ScreenChangedCallbackWrapper wrapper = this.mCallbacks.get(activity);
        return wrapper != null ? wrapper.wrappedCallback() : null;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    @Nullable
    ScreenChangedCallbackWrapper unwrappedCallback(@NonNull Activity activity) {
        return this.mCallbacks.get(activity);
    }

    static class ScreenChangedCallbackWrapper
    extends FragmentManager.FragmentLifecycleCallbacks
    implements IScreenChangedCallback {
        private final SparseArrayCompat<Long> mLoadingTimeMapper = new SparseArrayCompat();
        private final DateTimeUtil mDateTimeUtils;
        @NonNull
        private final IScreenChangedCallback mScreenChangedCallback;

        ScreenChangedCallbackWrapper(@NonNull DateTimeUtil dateTimeUtils, @NonNull IScreenChangedCallback screenChangedCallback) {
            this.mDateTimeUtils = dateTimeUtils;
            this.mScreenChangedCallback = screenChangedCallback;
        }

        public void onFragmentPreAttached(FragmentManager fm, Fragment fragment, Context context) {
            super.onFragmentPreAttached(fm, fragment, context);
            this.mLoadingTimeMapper.put(fragment.hashCode(), (Object)this.mDateTimeUtils.currentTimeMillis());
        }

        public void onFragmentStarted(FragmentManager fm, Fragment fragment) {
            int key = this.mLoadingTimeMapper.indexOfKey(fragment.hashCode());
            if (key < 0) {
                this.mLoadingTimeMapper.put(fragment.hashCode(), (Object)this.mDateTimeUtils.currentTimeMillis());
            }
            super.onFragmentStarted(fm, fragment);
        }

        public void onFragmentResumed(FragmentManager fm, Fragment fragment) {
            super.onFragmentResumed(fm, fragment);
            long currentTimeMillis = this.mDateTimeUtils.currentTimeMillis();
            int key = fragment.hashCode();
            long attachedTime = (Long)this.mLoadingTimeMapper.get(key, (Object)currentTimeMillis);
            long loadingTime = currentTimeMillis - attachedTime;
            this.mLoadingTimeMapper.remove(key);
            this.onScreenChanged((Activity)fragment.getActivity(), fragment, MathUtil.safeLongToInt(loadingTime));
        }

        @Override
        public void onScreenChanged(@NonNull Activity activity, @NonNull Fragment fragment, int loadingTime) {
            this.mScreenChangedCallback.onScreenChanged(activity, fragment, loadingTime);
        }

        @NonNull
        IScreenChangedCallback wrappedCallback() {
            return this.mScreenChangedCallback;
        }

        @RestrictTo(value={RestrictTo.Scope.TESTS})
        SparseArrayCompat<Long> loadingTimeMapper() {
            return this.mLoadingTimeMapper;
        }
    }
}

