/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.ui.glasspane;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import com.contentsquare.android.R;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.ui.glasspane.GlassPaneLayout;
import com.contentsquare.android.internal.ui.glasspane.IGlassPane;
import com.contentsquare.android.internal.util.ViewUtil;
import javax.inject.Inject;

public class GlassPane
implements IGlassPane {
    @NonNull
    private final Logger mLogger = new Logger("GlassPane");
    @NonNull
    private final GlassPaneLayout mGlassPaneLayout;
    @NonNull
    private final View mGlassCoverView;
    @Nullable
    private FrameLayout mDecorView;
    @Nullable
    private String mCurrentScreenUrl;

    @Inject
    @SuppressLint(value={"InflateParams"})
    public GlassPane(@NonNull Context context) {
        this((GlassPaneLayout)LayoutInflater.from((Context)context).inflate(R.layout.glass_pane, null, false), LayoutInflater.from((Context)context).inflate(R.layout.glass_pane_top, null, false));
    }

    public GlassPane(@NonNull GlassPaneLayout glassPaneLayout, @NonNull View glassCoverView) {
        this.mGlassPaneLayout = glassPaneLayout;
        this.mGlassCoverView = glassCoverView;
    }

    @Override
    @NonNull
    public final GlassPaneLayout getGlassPaneLayout() {
        return this.mGlassPaneLayout;
    }

    @Override
    public final void attachGlassPane(@NonNull Activity liveActivity) {
        this.mLogger.w("attaching Glass", new Object[0]);
        Window window = liveActivity.getWindow();
        this.mDecorView = (FrameLayout)window.findViewById(0x1020002);
        if (this.mDecorView == null) {
            return;
        }
        View view = this.mDecorView.getChildAt(0);
        if (view == null) {
            return;
        }
        GlassPaneLayout glass = this.getGlassPaneLayout();
        this.mDecorView.removeView(view);
        glass.addView(view);
        ViewUtil viewUtil = SingletonProvider.getAppComponent().getViewUtil();
        viewUtil.verifyViewDetached((View)glass);
        this.mDecorView.addView((View)glass);
        viewUtil.verifyViewDetached(this.mGlassCoverView);
        this.mDecorView.addView(this.mGlassCoverView);
        this.mGlassCoverView.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View view, MotionEvent event) {
                return false;
            }
        });
    }

    @Override
    public final void detachGlassPane(@Nullable Activity liveActivity) {
        this.mLogger.w("detaching Glass", new Object[0]);
        if (liveActivity != null) {
            Window window = liveActivity.getWindow();
            if (window == null) {
                return;
            }
            FrameLayout decorView = (FrameLayout)window.findViewById(0x1020002);
            if (decorView == null) {
                return;
            }
            this.restoreDecorViewToDefault(decorView);
        }
        this.mDecorView = null;
    }

    private void restoreDecorViewToDefault(@NonNull FrameLayout decorView) {
        decorView.setOnHierarchyChangeListener(null);
        GlassPaneLayout glass = (GlassPaneLayout)decorView.findViewById(R.id.cs_glass_pane);
        View glassTop = decorView.findViewById(R.id.cs_glass_pane_top);
        if (glass != null) {
            View child = glass.getChildAt(0);
            decorView.removeView((View)glass);
            glass.removeAllViews();
            if (child != null) {
                decorView.addView(child);
            }
        }
        if (glassTop != null) {
            decorView.removeView(glassTop);
        }
    }

    @Override
    public void stopSession() {
        if (this.mDecorView != null) {
            this.mDecorView.setOnHierarchyChangeListener(null);
            this.pauseListeners();
        }
    }

    @Override
    public void pauseListeners() {
        this.mGlassPaneLayout.pauseInterception();
    }

    @Override
    public void resumeListeners() {
        this.mGlassPaneLayout.resumeInterception();
    }

    @Override
    @Nullable
    public FrameLayout getDecorView() {
        return this.mDecorView;
    }

    @Override
    @Nullable
    public String getCurrentScreenUrl() {
        return this.mCurrentScreenUrl;
    }

    @Override
    public void setCurrentScreenUrl(@Nullable String currentScreenUrl) {
        this.mCurrentScreenUrl = currentScreenUrl;
    }
}

