/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.ui.glasspane;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.model.EventsFactory;
import com.contentsquare.android.internal.model.data.ActionEvent;
import com.contentsquare.android.internal.model.data.CrashEvent;
import com.contentsquare.android.internal.model.data.DoubleTapEvent;
import com.contentsquare.android.internal.model.data.DragEvent;
import com.contentsquare.android.internal.model.data.FlickEvent;
import com.contentsquare.android.internal.model.data.LongPressEvent;
import com.contentsquare.android.internal.model.data.TapEvent;
import com.contentsquare.android.internal.ui.glasspane.IGlassPane;
import com.contentsquare.android.internal.ui.processor.LayoutTraverser;
import com.contentsquare.android.internal.ui.processor.descriptors.PlaneDescriptor;
import com.contentsquare.android.internal.util.DateTimeUtil;
import com.contentsquare.android.internal.util.MathUtil;
import com.contentsquare.android.internal.util.ScreenRecorder;
import com.contentsquare.android.internal.util.ViewUtil;
import java.util.Stack;

public class GlassPaneLayout
extends LinearLayout {
    @VisibleForTesting
    static final int FINGER_THRESHOLD_VELOCITY = 1000;
    private static final int TAP_GESTURE_DISTANCE = 24;
    private static final long TAP_GESTURE_TIMEFRAME = 200L;
    private static final int DOUBLE_TAP_TIMEOUT = 200;
    private static final int TIME_PER_PIXEL = 1000;
    @VisibleForTesting
    final Handler mHandler = new Handler();
    private final Logger mLog = new Logger("Interceptor");
    @VisibleForTesting
    DateTimeUtil mDateTimeUtil;
    int mFingerDirection = 0;
    private boolean mEnableLogs = false;
    private boolean mPaused = false;
    private boolean mProcessingGesture = false;
    private int mTapStartX;
    private int mTapStartY;
    private long mGestureStart;
    private double mGestureDistance;
    private long mGestureDuration;
    private double mGestureVelocity;
    private int mGestureType;
    private long mGestureEnd;
    private int mTapEndX;
    private int mTapEndY;
    private PlaneDescriptor mPlane;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private Session mSession;
    @Nullable
    private ActionEvent mPendingUnhandled;

    public GlassPaneLayout(Context context) {
        super(context);
    }

    public GlassPaneLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GlassPaneLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public GlassPaneLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSession = SingletonProvider.getSessionComponent().getSession();
        this.mDateTimeUtil = SingletonProvider.getAppComponent().getDateTimeUtil();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (!this.mPaused) {
            this.processEvent(event);
        } else if (this.mEnableLogs) {
            this.mLog.w("Event Interception paused", new Object[0]);
        }
        return super.dispatchTouchEvent(event);
    }

    public void pauseInterception() {
        this.mPaused = true;
    }

    public void resumeInterception() {
        this.mPaused = false;
    }

    private void processEvent(MotionEvent event) {
        int eventRawX = (int)event.getRawX();
        int eventRawY = (int)event.getRawY();
        if (this.mEnableLogs) {
            this.mLog.d("Found: got event: %s", event.toString());
        }
        switch (event.getAction()) {
            case 0: {
                this.processActionDown(event);
                this.initiateVelocityTracker(event);
                return;
            }
            case 2: {
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.addMovement(event);
                }
                this.mPendingUnhandled = null;
                return;
            }
            case 3: {
                this.reset();
                return;
            }
            case 1: {
                int index = event.getActionIndex();
                int pointerId = event.getPointerId(index);
                this.updateVelocity(pointerId);
                this.mGestureType = -1;
                this.processActionUp(eventRawX, eventRawY);
                break;
            }
            default: {
                if (this.mEnableLogs) {
                    this.mLog.w("Found: unhandled event: %s", event.toString());
                }
                this.mPendingUnhandled = null;
                return;
            }
        }
        if (this.mEnableLogs) {
            this.mLog.i("Found : mGestureType: %b mGestureDistance: %d mGestureDuration: %l eventRawX: %b eventRawY:%b", this.mGestureType, this.mGestureDistance, this.mGestureDuration, eventRawX, eventRawY);
        }
        if (this.mGestureType == -1) {
            return;
        }
        this.createScreenEvent(this.mGestureType, this.mPlane);
    }

    private void recordUnhandledTouch() {
        EventsFactory factory = this.mSession.getEventsFactory();
        boolean unresponsive = true;
        this.mPendingUnhandled = this.buildTapEvent(factory, this.mPlane, this.mPlane.getTargetPathDescriptor(), unresponsive);
    }

    private void sendUnhandled() {
        this.mSession.getEventsProcessor().processEvent(this.mSession.getJsonProxy().serializeToJson(this.mPendingUnhandled));
    }

    private void processActionDown(@NonNull MotionEvent event) {
        int eventRawX = (int)event.getRawX();
        int eventRawY = (int)event.getRawY();
        IGlassPane glass = SingletonProvider.getSessionComponent().getSession().getGlass();
        FrameLayout decor = glass.getDecorView();
        if (decor == null) {
            this.mLog.e("decor view is null, exiting...", new Object[0]);
            return;
        }
        this.mPlane = this.getTouchTarget((ViewGroup)glass.getDecorView(), eventRawX, eventRawY);
        if (this.mProcessingGesture) {
            this.sendUnhandled();
            this.reset();
        }
        this.recordUnhandledTouch();
        this.mProcessingGesture = true;
        this.mTapStartX = ViewUtil.convertPixelsToDps(eventRawX, this.getContext());
        this.mTapStartY = ViewUtil.convertPixelsToDps(eventRawY, this.getContext());
        this.mGestureStart = this.mDateTimeUtil.currentTimeMillis();
    }

    private void processActionUp(int eventRawX, int eventRawY) {
        if (this.mProcessingGesture) {
            this.mProcessingGesture = false;
            this.mTapEndX = ViewUtil.convertPixelsToDps(eventRawX, this.getContext());
            this.mTapEndY = ViewUtil.convertPixelsToDps(eventRawY, this.getContext());
            this.mGestureEnd = this.mDateTimeUtil.currentTimeMillis();
            this.mGestureDistance = MathUtil.euclideanDistance(this.mTapStartX, this.mTapStartY, this.mTapEndX, this.mTapEndY);
            this.mGestureDuration = this.mGestureEnd - this.mGestureStart;
            if (this.mGestureDistance > 24.0) {
                this.mGestureType = this.mGestureVelocity > 1000.0 ? 10 : 9;
                this.updateFingerDirection(this.mTapStartX, this.mTapEndX, this.mTapStartY, this.mTapEndY);
            } else {
                this.mGestureType = this.mGestureDuration < 200L ? 6 : 8;
            }
        } else {
            if (this.mEnableLogs) {
                this.mLog.e("Found : We're not processing a gesture? Something is wrong", new Object[0]);
            }
            this.mGestureType = -1;
        }
    }

    @VisibleForTesting
    @NonNull
    PlaneDescriptor getTouchTarget(@NonNull ViewGroup parent, final int touchX, final int touchY) {
        final Stack targets = new Stack();
        LayoutTraverser.build(new LayoutTraverser.Processor(){

            @Override
            public void process(@NonNull View view) {
                if (this.checkIfViewFitsTarget(view) && view.getVisibility() == 0) {
                    targets.add(view);
                }
            }

            @Override
            public void process(@NonNull ViewGroup viewGroup) {
                if (this.checkIfViewFitsTarget((View)viewGroup) && viewGroup.getVisibility() == 0) {
                    targets.add(viewGroup);
                }
            }

            private boolean checkIfViewFitsTarget(@NonNull View view) {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                int width = view.getWidth();
                int height = view.getHeight();
                return MathUtil.isPointInPlane(location[0], location[1], width, height, touchX, touchY);
            }
        }).traverse(parent);
        targets.pop();
        View targetView = (View)targets.pop();
        targets.clear();
        return PlaneDescriptor.getDescriptorFor(targetView);
    }

    @VisibleForTesting
    VelocityTracker getVelocityTracker() {
        return VelocityTracker.obtain();
    }

    @VisibleForTesting
    void createScreenEvent(int gestureType, @NonNull PlaneDescriptor plane) {
        ActionEvent event;
        EventsFactory factory = this.mSession.getEventsFactory();
        switch (gestureType) {
            case 6: {
                boolean unresponsive = false;
                String targetPathDescriptor = plane.getTargetPathDescriptor();
                event = this.buildTapEvent(factory, plane, targetPathDescriptor, unresponsive);
                break;
            }
            case 7: {
                String targetPathDescriptor = plane.getTargetPathDescriptor();
                event = this.buildDoubleTapEvent(factory, plane, targetPathDescriptor);
                break;
            }
            case 8: {
                String targetPathDescriptor = plane.getTargetPathDescriptor();
                event = this.buildLongPressEvent(factory, plane, targetPathDescriptor);
                this.getScreenRecorder().capture((ViewGroup)this.mSession.getGlass().getDecorView(), this.mSession.getGlass().getCurrentScreenUrl(), this.getTargetPathId(targetPathDescriptor));
                break;
            }
            case 9: {
                String targetPathDescriptor = plane.getTargetPathDescriptor();
                event = this.buildDragEvent(factory, plane, targetPathDescriptor);
                break;
            }
            case 10: {
                String targetPathDescriptor = plane.getTargetPathDescriptor();
                event = this.buildFlickEvent(factory, plane, targetPathDescriptor);
                break;
            }
            default: {
                Object targetPathDescriptor = null;
                CrashEvent.CrashEventBuilder crashBuilder = (CrashEvent.CrashEventBuilder)factory.produceEvent(gestureType);
                crashBuilder.setCrashOrigin(1);
                crashBuilder.setFatal(false);
                crashBuilder.setMessage("Failed to get event for type: " + gestureType);
                event = crashBuilder.build();
            }
        }
        this.mSession.getEventsProcessor().processEvent(this.mSession.getJsonProxy().serializeToJson(event));
    }

    private int getTargetPathId(@Nullable String targetPathDescriptor) {
        return targetPathDescriptor != null ? targetPathDescriptor.hashCode() : 0;
    }

    @NonNull
    @VisibleForTesting
    ScreenRecorder getScreenRecorder() {
        return SingletonProvider.getSessionComponent().getScreenRecorder();
    }

    @NonNull
    private ActionEvent buildTapEvent(@NonNull EventsFactory factory, @NonNull PlaneDescriptor plane, @NonNull String targetPathDescriptor, boolean unresponsive) {
        TapEvent.TapEventBuilder tapBuilder = (TapEvent.TapEventBuilder)factory.produceEvent(6);
        return tapBuilder.setTouchPath(targetPathDescriptor).setViewId(plane.getViewResourceId()).setTouchUnresponsive(unresponsive).setViewAccessibilityLabel(plane.getViewAccessibilityLabel()).setViewLabel(plane.getViewLabel()).build();
    }

    @NonNull
    private ActionEvent buildDoubleTapEvent(@NonNull EventsFactory factory, @NonNull PlaneDescriptor plane, @NonNull String targetPathDescriptor) {
        DoubleTapEvent.DoubleTapEventBuilder doubleTapEventBuilder = (DoubleTapEvent.DoubleTapEventBuilder)factory.produceEvent(7);
        return doubleTapEventBuilder.setTouchPath(targetPathDescriptor).setViewId(plane.getViewResourceId()).setViewAccessibilityLabel(plane.getViewAccessibilityLabel()).setViewLabel(plane.getViewLabel()).build();
    }

    @NonNull
    private ActionEvent buildLongPressEvent(@NonNull EventsFactory factory, @NonNull PlaneDescriptor plane, @NonNull String targetPathDescriptor) {
        LongPressEvent.LongPressEventBuilder longPressEventBuilder = (LongPressEvent.LongPressEventBuilder)factory.produceEvent(8);
        return longPressEventBuilder.setTouchPath(targetPathDescriptor).setViewId(plane.getViewResourceId()).setViewAccessibilityLabel(plane.getViewAccessibilityLabel()).setViewLabel(plane.getViewLabel()).build();
    }

    @NonNull
    private ActionEvent buildDragEvent(@NonNull EventsFactory factory, @NonNull PlaneDescriptor plane, @NonNull String targetPathDescriptor) {
        DragEvent.DragEventBuilder dragEventBuilder = (DragEvent.DragEventBuilder)factory.produceEvent(9);
        return dragEventBuilder.setTouchPath(targetPathDescriptor).setViewId(plane.getViewResourceId()).setViewAccessibilityLabel(plane.getViewAccessibilityLabel()).setViewLabel(plane.getViewLabel()).setFingerDirection(this.mFingerDirection).setTargetViewDistanceDragged((int)this.mGestureDistance).setTargetViewVelocity((int)this.mGestureVelocity).build();
    }

    @NonNull
    private ActionEvent buildFlickEvent(@NonNull EventsFactory factory, @NonNull PlaneDescriptor plane, @NonNull String targetPathDescriptor) {
        FlickEvent.FlickEventBuilder flickEventBuilder = (FlickEvent.FlickEventBuilder)factory.produceEvent(10);
        return flickEventBuilder.setTouchPath(targetPathDescriptor).setViewId(plane.getViewResourceId()).setViewAccessibilityLabel(plane.getViewAccessibilityLabel()).setViewLabel(plane.getViewLabel()).setFingerDirection(this.mFingerDirection).setTargetViewDistanceDragged((int)this.mGestureDistance).setTargetViewVelocity((int)this.mGestureVelocity).build();
    }

    private void reset() {
        if (this.mEnableLogs) {
            this.mLog.w("Found: resetting state, action cancel or rogue event ", new Object[0]);
        }
        this.mProcessingGesture = false;
        this.mPendingUnhandled = null;
        this.mTapStartX = -1;
        this.mTapStartY = -1;
        this.mGestureStart = -1L;
        this.mGestureDistance = -1.0;
        this.mGestureDuration = -1L;
        this.mGestureVelocity = -1.0;
        this.mFingerDirection = 0;
        this.mGestureType = -1;
        this.mGestureEnd = -1L;
        this.mTapEndX = -1;
        this.mTapEndY = -1;
        this.recycleVelocityTracker();
    }

    @VisibleForTesting
    private void updateVelocity(int pointerId) {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.computeCurrentVelocity(1000);
            int pxVelocityX = MathUtil.safeFloatToInt(this.mVelocityTracker.getXVelocity(pointerId));
            int pxVelocityY = MathUtil.safeFloatToInt(this.mVelocityTracker.getYVelocity(pointerId));
            Context context = SingletonProvider.getAppComponent().getApplication().getApplicationContext();
            int dpVelocityX = ViewUtil.convertPixelsToDps(pxVelocityX, context);
            int dpVelocityY = ViewUtil.convertPixelsToDps(pxVelocityY, context);
            this.mGestureVelocity = Math.sqrt(Math.pow(dpVelocityX, 2.0) + Math.pow(dpVelocityY, 2.0));
        }
    }

    private void updateFingerDirection(float tapStartX, float tapEndX, float tapStartY, float tapEndY) {
        float directionX = tapEndX - tapStartX;
        float directionY = tapEndY - tapStartY;
        this.mFingerDirection = this.getFingerDirection(directionX, directionY);
    }

    private int getFingerDirection(float directionX, float directionY) {
        int fingerDirection = Math.abs(directionX) > Math.abs(directionY) ? (directionX > 0.0f ? 4 : 3) : (directionY > 0.0f ? 2 : 1);
        return fingerDirection;
    }

    private void initiateVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = this.getVelocityTracker();
        } else {
            this.mVelocityTracker.clear();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }
}

