/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.ui.processor.descriptors;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.ResourceUtils;
import com.contentsquare.android.internal.util.Strings;
import java.util.Locale;

public class PathDescriptor {
    @NonNull
    public String generateAnalyticsPath(@Nullable View view) {
        StringBuilder data = new StringBuilder("[root]>");
        if (view != null) {
            this.processLeaf(view, data);
        }
        data.deleteCharAt(data.length() - 1);
        return data.toString();
    }

    private void processLeaf(@NonNull View view, @NonNull StringBuilder data) {
        ViewGroup parent = null;
        if (view.getParent() instanceof ViewGroup) {
            parent = (ViewGroup)view.getParent();
        } else {
            new Logger("path").w("discarding parent as it's not a ViewGroup", new Object[0]);
        }
        if (parent == null || parent.getClass().toString().endsWith("widget.FitWindowsLinearLayout")) {
            return;
        }
        String className = view.getClass().getSimpleName();
        this.processLeaf((View)parent, data);
        if (!className.startsWith("GlassPaneLayout")) {
            data.append(className);
        }
        for (int itemPos = 0; itemPos < parent.getChildCount(); ++itemPos) {
            View child = parent.getChildAt(itemPos);
            if (child != view) continue;
            String id2 = ResourceUtils.getResourceEntryName(child, "");
            if (id2.contains("cs_glass_pane")) break;
            data.append(String.format(Locale.getDefault(), ":eq(%d)", itemPos));
            if (!Strings.isNullOrEmpty(id2)) {
                data.append('#').append(id2);
            }
            data.append('>');
            break;
        }
    }
}

