/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.ui.processor.descriptors;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.ui.processor.descriptors.PathDescriptor;
import com.contentsquare.android.internal.ui.processor.descriptors.ViewDescriptor;
import com.contentsquare.android.internal.ui.processor.descriptors.ViewGroupDescriptor;
import com.contentsquare.android.internal.util.ResourceUtils;

public abstract class PlaneDescriptor {
    @VisibleForTesting
    final PathDescriptor mPathDescriptor = new PathDescriptor();
    private final Logger mLogger = new Logger("PlaneDescriptor");
    private int mTopX;
    private int mTopY;
    private int mBottomX;
    private int mBottomY;
    private boolean mEnabled;
    private String mClassName;
    private CharSequence mAccessibilityClassName;
    private boolean mActivated;
    private boolean mClickable;
    private boolean mFocusable;
    private boolean mFocused;
    private boolean mIsShown;
    private String mViewResourceId;
    private int mViewId;
    private int mChildCount = -1;
    private boolean mTouchBlockingFocus = false;
    private boolean mVisible;
    private String mViewLabel;
    private String mViewAccessibilityLabel;
    private String mTargetPathDescriptor;

    PlaneDescriptor(@NonNull View view) {
        int[] top = new int[2];
        view.getLocationOnScreen(top);
        this.mTopX = top[0];
        this.mTopY = top[1];
        DeviceInfo deviceInfo = SingletonProvider.getAppComponent().getDeviceInfo();
        int statusBarHeight = deviceInfo.getStatusBarHeight();
        int actionBarHeight = deviceInfo.calculateActionBarHeight();
        this.mBottomX = this.mTopX + view.getWidth();
        this.mBottomY = this.mTopY + view.getHeight();
        this.mTopY -= statusBarHeight;
        this.mTopY -= actionBarHeight;
        this.mBottomY -= statusBarHeight;
        this.mBottomY -= actionBarHeight;
        try {
            String classname;
            this.mClassName = classname = view.getParent().getClass().getSimpleName();
            this.mViewResourceId = ResourceUtils.getResourceEntryName((View)view.getParent(), null);
        }
        catch (NullPointerException e) {
            this.mLogger.e(e, "Failed to get class name", new Object[0]);
        }
        if (view instanceof TextView) {
            CharSequence text = ((TextView)view).getText();
            this.mViewLabel = String.valueOf(text);
        }
        CharSequence description = view.getContentDescription();
        this.mViewAccessibilityLabel = String.valueOf(description);
        this.mTargetPathDescriptor = this.mPathDescriptor.generateAnalyticsPath(view);
    }

    @NonNull
    public static PlaneDescriptor getDescriptorFor(@NonNull View targetView) {
        if (targetView instanceof ViewGroup) {
            return new ViewGroupDescriptor((ViewGroup)targetView);
        }
        return new ViewDescriptor(targetView);
    }

    public int getTopX() {
        return this.mTopX;
    }

    public int getTopY() {
        return this.mTopY;
    }

    public int getBottomX() {
        return this.mBottomX;
    }

    public int getBottomY() {
        return this.mBottomY;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public String getClassName() {
        return this.mClassName;
    }

    void setClassName(String className) {
        this.mClassName = className;
    }

    public CharSequence getAccessibilityClassName() {
        return this.mAccessibilityClassName;
    }

    void setAccessibilityClassName(CharSequence accessibilityClassName) {
        this.mAccessibilityClassName = accessibilityClassName;
    }

    public boolean isActivated() {
        return this.mActivated;
    }

    void setActivated(boolean activated) {
        this.mActivated = activated;
    }

    public boolean isClickable() {
        return this.mClickable;
    }

    void setClickable(boolean clickable) {
        this.mClickable = clickable;
    }

    public boolean isFocusable() {
        return this.mFocusable;
    }

    void setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    public boolean isFocused() {
        return this.mFocused;
    }

    void setFocused(boolean focused) {
        this.mFocused = focused;
    }

    public boolean isShown() {
        return this.mIsShown;
    }

    void setShown(boolean shown) {
        this.mIsShown = shown;
    }

    public int getViewId() {
        return this.mViewId;
    }

    void setViewId(int viewId) {
        this.mViewId = viewId;
    }

    public String getViewResourceId() {
        return this.mViewResourceId;
    }

    void setViewResourceId(String viewResourceId) {
        this.mViewResourceId = viewResourceId;
    }

    public int getChildCount() {
        return this.mChildCount;
    }

    void setChildCount(int childCount) {
        this.mChildCount = childCount;
    }

    boolean isTouchBlockingFocus() {
        return this.mTouchBlockingFocus;
    }

    void setTouchBlockingFocus(boolean touchBlockingFocus) {
        this.mTouchBlockingFocus = touchBlockingFocus;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    @NonNull
    public String getTargetPathDescriptor() {
        return this.mTargetPathDescriptor;
    }

    public String getViewLabel() {
        return this.mViewLabel;
    }

    public String getViewAccessibilityLabel() {
        return this.mViewAccessibilityLabel;
    }
}

