/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.ui.processor.descriptors;

import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import com.contentsquare.android.internal.ui.processor.descriptors.PlaneDescriptor;
import com.contentsquare.android.internal.util.ResourceUtils;

public class ViewDescriptor
extends PlaneDescriptor {
    public ViewDescriptor(@NonNull View view) {
        super(view);
        this.setClassName(view.getClass().getSimpleName());
        if (view.getId() > 0) {
            this.setViewResourceId(ResourceUtils.getResourceEntryName(view, "null"));
            this.setViewId(view.getId());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.setAccessibilityClassName(view.getAccessibilityClassName());
        } else {
            this.setAccessibilityClassName("");
        }
        this.setEnabled(view.isEnabled());
        this.setActivated(view.isActivated());
        this.setClickable(view.isClickable());
        this.setFocusable(view.isFocusable());
        this.setFocused(view.isFocused());
        this.setShown(view.isShown());
        this.setVisible(view.getVisibility() == 0);
    }
}

