/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.ui.processor.descriptors;

import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.contentsquare.android.internal.ui.processor.descriptors.PlaneDescriptor;
import com.contentsquare.android.internal.util.ResourceUtils;

public class ViewGroupDescriptor
extends PlaneDescriptor {
    public ViewGroupDescriptor(@NonNull ViewGroup viewGroup) {
        super((View)viewGroup);
        this.setClassName(viewGroup.getClass().getSimpleName());
        if (viewGroup.getId() > 0) {
            this.setViewId(viewGroup.getId());
            this.setViewResourceId(ResourceUtils.getResourceEntryName((View)viewGroup, "null"));
        }
        this.setChildCount(viewGroup.getChildCount());
        if (Build.VERSION.SDK_INT >= 23) {
            this.setAccessibilityClassName(viewGroup.getAccessibilityClassName());
            this.setTouchBlockingFocus(viewGroup.getTouchscreenBlocksFocus());
        } else {
            this.setAccessibilityClassName("");
            this.setTouchBlockingFocus(false);
        }
        this.setEnabled(viewGroup.isEnabled());
        this.setActivated(viewGroup.isActivated());
        this.setClickable(viewGroup.isClickable());
        this.setFocusable(viewGroup.isFocusable());
        this.setFocused(viewGroup.isFocused());
        this.setShown(viewGroup.isShown());
        this.setVisible(viewGroup.getVisibility() == 0);
    }
}

