/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.logging.Logger;
import java.io.IOException;
import java.io.InputStream;

public class AssetManager {
    private static final String BASE_CONFIG = "baseconfig.json";
    private static final Logger LOG = new Logger("AssetManager");
    private final Context mContext;

    public AssetManager(@NonNull Context context) {
        this.mContext = context;
    }

    @VisibleForTesting
    @Nullable
    String loadFileFromAsset(@NonNull String filename) {
        String fileContent;
        try {
            InputStream is = this.mContext.getAssets().open(filename);
            int size = is.available();
            byte[] buffer = new byte[size];
            int readBuffer = is.read(buffer);
            LOG.d("Bytes read: %d", readBuffer);
            is.close();
            fileContent = new String(buffer, "UTF-8");
        }
        catch (IOException ex) {
            LOG.e(ex, "Failed to read file from assets.", new Object[0]);
            return null;
        }
        return fileContent;
    }

    @Nullable
    public String loadBaseConfigFromAsset() {
        return this.loadFileFromAsset(BASE_CONFIG);
    }
}

