/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.ConfigurationCompositor;
import com.contentsquare.android.internal.dagger.SingletonProvider;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.util.Strings;
import javax.inject.Inject;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigurationHelper {
    public static final String LAST_CONFIG_LABEL = "config";
    public static final String LAST_KNOWN_CONFIG = "last_config";
    public static final String USERID = "uid";
    public static final String USERID_CONFIG = "uid_config";
    static final String TIMESTAMP = "timestamp";
    static final long TTL = 604800000L;
    static final long USERID_TTL = 33696000000L;
    private final long mNow = System.currentTimeMillis();
    @Inject
    @VisibleForTesting
    PrefsHelper mPrefsHelper;
    @Inject
    @VisibleForTesting
    ConfigurationCompositor mConfigurationCompositor;
    private final Logger mLogger = new Logger("ConfigurationHelper");

    public ConfigurationHelper() {
        SingletonProvider.getAppComponent().inject(this);
    }

    @Nullable
    public String getLastClientConfig() {
        String serializedJson = this.mPrefsHelper.getString(LAST_KNOWN_CONFIG, null);
        this.mLogger.d("retrieving last config from preferences", new Object[0]);
        if (Strings.isNullOrEmpty(serializedJson)) {
            this.mLogger.d("last config is null", new Object[0]);
            return null;
        }
        try {
            JSONObject configWithTtl = new JSONObject(serializedJson);
            long timestamp = configWithTtl.getLong(TIMESTAMP);
            if (this.mNow - timestamp > 604800000L) {
                this.mLogger.d("last config is outdated, returning null", new Object[0]);
                this.mPrefsHelper.deleteAndResetAll();
                return null;
            }
            this.mLogger.d("last config is valid, returning config from preferences", new Object[0]);
            String jsonConfig = configWithTtl.getString(LAST_CONFIG_LABEL);
            if (this.mConfigurationCompositor.validateConfig(jsonConfig)) {
                return jsonConfig;
            }
            return null;
        }
        catch (JSONException e) {
            this.mLogger.e(e, "failed to deserialize last config with an exception", new Object[0]);
            return null;
        }
    }

    public void setLastConfig(@Nullable String config) {
        if (Strings.isNullOrEmpty(config)) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(LAST_CONFIG_LABEL, (Object)config);
            jsonObject.put(TIMESTAMP, System.currentTimeMillis());
            this.mPrefsHelper.putString(LAST_KNOWN_CONFIG, jsonObject.toString());
        }
        catch (JSONException e) {
            this.mLogger.e(e, "Failed to serialize and store the config.", new Object[0]);
        }
    }

    public void setUserIdConfig(@NonNull String uid) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(USERID, (Object)uid);
            jsonObject.put(TIMESTAMP, System.currentTimeMillis());
            this.mPrefsHelper.putString(USERID_CONFIG, jsonObject.toString());
            this.mLogger.d("Saving USER ID config to sharedPrefs.", new Object[0]);
        }
        catch (JSONException e) {
            this.mLogger.e(e, "Failed to serialize and store the USER ID config.", new Object[0]);
        }
    }

    @Nullable
    public String getLastUserIdConfig() {
        String serializedJson = this.mPrefsHelper.getString(USERID_CONFIG, null);
        this.mLogger.w("retrieving last USER ID config from preferences", new Object[0]);
        if (Strings.isNullOrEmpty(serializedJson)) {
            this.mLogger.w("last USER ID config is null", new Object[0]);
            return null;
        }
        try {
            JSONObject configWithTtl = new JSONObject(serializedJson);
            long timestamp = configWithTtl.getLong(TIMESTAMP);
            if (this.mNow - timestamp > 33696000000L) {
                this.mLogger.w("last USER ID is outdated, returning null", new Object[0]);
                this.mPrefsHelper.deleteAndResetAll();
                return null;
            }
            this.mLogger.w("last USER ID is valid, returning USER ID from preferences %s", configWithTtl.getString(USERID));
            return configWithTtl.getString(USERID);
        }
        catch (JSONException e) {
            this.mLogger.e(e, "failed to deserialize last USER ID config with an exception", new Object[0]);
            return null;
        }
    }
}

