/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class FileStorageUtil {
    private static final String DATA_CONTAINER = "ContentSquare";
    private final Logger mLogger = new Logger("FileStorageUtil");
    @VisibleForTesting
    String mAppFilesLocation = null;

    public boolean prepareAndReset(@IntRange(from=0L) int sessionId, @NonNull String mainDirPath) {
        this.mAppFilesLocation = mainDirPath;
        return this.createStorageFolderIfNotExist(String.valueOf(sessionId));
    }

    public boolean prepareFile(@NonNull String folder, @NonNull String file) {
        return this.createFileIfNotExist(folder, file);
    }

    public void appendStringToFile(@NonNull String folderName, @NonNull String filename, @NonNull String data) {
        File file = this.getFile(this.getFolderPath(folderName).append(File.separator).append(filename).toString());
        String dataString = data.replace("\n", "") + "\n";
        if (file.exists()) {
            try {
                FileOutputStream fileOutputStream = this.getFileOutputStream(file, true);
                fileOutputStream.write(dataString.getBytes(Charset.forName("UTF-8")));
                fileOutputStream.close();
                this.mLogger.d("Writting to File: %s", dataString);
            }
            catch (IOException e) {
                this.mLogger.e(e, " Data not written to file", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public List<String> readFileContentByLine(@NonNull String folderName, @NonNull String filename) {
        File file = this.getFile(this.getFolderPath(folderName).append(File.separator).append(filename).toString());
        LinkedList<String> listEvents = new LinkedList<String>();
        FileInputStream fileInputStream = null;
        if (file.exists()) {
            try {
                String line;
                fileInputStream = this.getFileInputStream(file);
                BufferedReader reader = this.getBufferReader(this.getInputStreamReader(fileInputStream));
                while ((line = reader.readLine()) != null) {
                    this.mLogger.d("File Data: %s", line);
                    listEvents.add(line);
                }
            }
            catch (IOException | NullPointerException e) {
                this.mLogger.e(e, "Failed while reading file : %s/%s", folderName, filename);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    this.mLogger.w(e, "Failed to close stream", new Object[0]);
                }
            }
        }
        return listEvents;
    }

    public int getNumberOfItemsInFolder(@NonNull String folderName) {
        File folder = this.getFile(this.getFolderPath(folderName).toString());
        String[] lister = folder.list();
        if (lister == null) {
            return 0;
        }
        return lister.length;
    }

    public boolean deleteFile(@NonNull String folderName, @NonNull String filename) {
        File file = this.getFile(this.getFolderPath(folderName).append(File.separator).append(filename).toString());
        this.mLogger.w("File to delete: %s", file.getPath());
        return file.delete();
    }

    private boolean createStorageFolderIfNotExist(@NonNull String folderName) {
        File folder = this.getFile(this.getFolderPath(folderName).toString());
        return !folder.exists() && folder.mkdirs();
    }

    private StringBuilder getFolderPath(String folderName) {
        return new StringBuilder().append(this.mAppFilesLocation).append(File.separator).append(DATA_CONTAINER).append(File.separator).append(folderName);
    }

    private boolean createFileIfNotExist(@NonNull String folderName, @Nullable String filename) {
        File file = this.getFile(this.getFolderPath(folderName).append(File.separator).append(filename).toString());
        if (!file.exists()) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                this.mLogger.e(e, "Error creating File %s ", file.getPath());
                return false;
            }
        }
        this.mLogger.d("File exists %s ", file.getPath());
        return true;
    }

    @VisibleForTesting
    File getFile(String path) {
        return new File(path);
    }

    @VisibleForTesting
    FileOutputStream getFileOutputStream(File file, boolean append) throws FileNotFoundException {
        return new FileOutputStream(file, append);
    }

    @VisibleForTesting
    FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    @VisibleForTesting
    InputStreamReader getInputStreamReader(FileInputStream fileInputStream) {
        return new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
    }

    @VisibleForTesting
    BufferedReader getBufferReader(InputStreamReader inputStreamReader) {
        return new BufferedReader(inputStreamReader);
    }

    @NonNull
    public String[] getMainDirectoryList() {
        String mainDir = this.mAppFilesLocation + File.separator + DATA_CONTAINER;
        File directory = this.getFile(mainDir);
        this.mLogger.d("Directory: %s", directory.getName());
        if (directory.list() == null) {
            this.mLogger.e("Can't access Folder : %s", directory.getName());
            return new String[0];
        }
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            String[] fileNames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileNames[i] = files[i].getAbsolutePath();
            }
            return fileNames;
        }
        return new String[0];
    }

    @NonNull
    public File[] getFileList(@NonNull File directory) {
        this.mLogger.d("Directory: %s", directory.getName());
        return directory.listFiles();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void cleanupFolder(@NonNull String folderName) {
        String dir = this.mAppFilesLocation + File.separator + DATA_CONTAINER + File.separator + folderName;
        File folder = this.getFile(dir);
        String[] content = folder.list();
        this.mLogger.w("Folder to delete: %s", folder.getPath());
        if (content != null && content.length == 0) {
            boolean deleted = folder.delete();
            this.mLogger.w("folder %s deleted : %b", folderName, deleted);
        }
    }

    public boolean isDirectory(@NonNull File directory) {
        boolean isDir = false;
        if (directory.isDirectory()) {
            isDir = true;
        }
        return isDir;
    }

    public boolean readable(@NonNull File directory) {
        boolean isReadable = false;
        if (directory.canRead()) {
            isReadable = true;
        }
        return isReadable;
    }
}

