/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.Pair;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.json.JSONObject;

public class HttpConnection {
    static final String GET = "GET";
    static final String POST = "POST";
    static final String HEAD = "HEAD";
    static final String OPTIONS = "OPTIONS";
    static final String PUT = "PUT";
    static final String DELETE = "DELETE";
    static final String TRACE = "TRACE";
    static final int TIMEOUT_CONNECT = 1000;
    private static final int TIMEOUT_READ = 10000;
    private static final char EQUALS = '=';
    private static final char AND = '&';
    private final Logger mLog = new Logger("HttpConnection");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="We are OK with this not being a static class.")
    @NonNull
    public HttpResponse performGetWithFormdata(@NonNull String endpoint, @Nullable List<Pair> args) {
        HttpURLConnection connection = null;
        HttpResponse response = new HttpResponse();
        try {
            String requestUrl = this.buildGetUrl(endpoint, args);
            connection = this.openConnection(GET, requestUrl, null);
            connection.connect();
            response.setStatus(connection.getResponseCode());
            this.mLog.d("GET: Connection open, status %d, url : %s ", response.getStatus(), requestUrl);
            if (response.getStatus() == 200) {
                response.setStringResponse(this.readStream(connection.getInputStream()));
            }
        }
        catch (IOException | NullPointerException e) {
            this.mLog.e(e, "Exception while processing HttpGet Request on %s ", endpoint);
            response.setStatus(500);
            response.setException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public HttpResponse performPostWithJson(@NonNull String endpoint, @NonNull JSONObject json) {
        this.mLog.i("Performing post on %s with %s ", endpoint, json);
        HttpURLConnection connection = null;
        try {
            String requestData = json.toString();
            connection = this.openConnection(POST, endpoint, requestData);
            HttpResponse httpResponse = this.performPost(connection, endpoint, requestData);
            return httpResponse;
        }
        catch (IOException | NullPointerException e) {
            this.mLog.e(e, "Exception while processing HttpPOST Request on %s \n  for json: %s", endpoint, json);
            HttpResponse httpResponse = this.handleError(e);
            return httpResponse;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpResponse handleError(Exception exception) {
        HttpResponse response = new HttpResponse();
        response.setStatus(500);
        response.setException(exception);
        return response;
    }

    @NonNull
    @VisibleForTesting
    HttpResponse performPost(@NonNull HttpURLConnection connection, @NonNull String endpoint, @NonNull String processedArgs) throws IOException {
        HttpResponse response = new HttpResponse();
        OutputStream wr = connection.getOutputStream();
        wr.write(processedArgs.trim().getBytes("UTF-8"));
        wr.flush();
        wr.close();
        response.setStatus(connection.getResponseCode());
        this.mLog.d("POST: Connection open, status %s, url : %s", String.valueOf(response.getStatus()), endpoint);
        if (response.getStatus() == 200) {
            response.setStringResponse(this.readStream(connection.getInputStream()));
        }
        this.mLog.i("Received response : %s", response.getStringResponse());
        return response;
    }

    @NonNull
    @VisibleForTesting
    HttpURLConnection openConnection(@NonNull String method, @NonNull String endpoint, @Nullable String encodedArgs) throws IOException {
        this.mLog.d("opening a %s connection to %s", method, endpoint);
        URL url = new URL(endpoint);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setRequestProperty("Charset", "UTF-8");
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setConnectTimeout(1000);
        connection.setReadTimeout(10000);
        switch (method) {
            case "GET": {
                connection.setRequestProperty("Content-length", "0");
                break;
            }
            case "POST": {
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("HTTP Methods other than POST and GET are not implemented.");
            }
        }
        return connection;
    }

    @VisibleForTesting
    String buildGetUrl(@NonNull String url, @Nullable List<Pair> arguments) {
        if (arguments == null) {
            return url;
        }
        Uri.Builder builder = Uri.parse((String)url).buildUpon();
        for (Pair pair : arguments) {
            builder.appendQueryParameter(pair.first.toString(), pair.second.toString());
        }
        String derivedUrl = builder.build().toString();
        this.mLog.d("Get URL transformed to %s", url, "");
        return derivedUrl;
    }

    @Nullable
    @VisibleForTesting
    String urlEncodeRequestParameters(@Nullable List<Pair> arguments) {
        if (arguments == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = arguments.get(i);
            builder.append(Strings.encode(String.valueOf(pair.first))).append('=').append(Strings.encode(String.valueOf(pair.second)));
            if (i >= size - 1) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    @VisibleForTesting
    String readStream(InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line).append('\n');
        }
        br.close();
        return sb.toString();
    }

    public class HttpResponse {
        private int mStatus = -1;
        private String mStringResponse = null;
        private Throwable mException = null;

        HttpResponse() {
        }

        public int getStatus() {
            return this.mStatus;
        }

        void setStatus(int status) {
            this.mStatus = status;
        }

        @Nullable
        public String getStringResponse() {
            return this.mStringResponse;
        }

        void setStringResponse(String stringResponse) {
            this.mStringResponse = stringResponse;
        }

        @Nullable
        public Throwable getException() {
            return this.mException;
        }

        public void setException(Throwable exception) {
            this.mException = exception;
        }

        public boolean positive() {
            return this.getStatus() == 200;
        }
    }
}

