/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.support.annotation.Nullable;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.Strings;
import java.security.MessageDigest;

public class MD5Hash {
    @Nullable
    private String mData = null;

    public MD5Hash(@Nullable String dataToHash) {
        if (!Strings.isNullOrEmpty(dataToHash)) {
            try {
                MessageDigest hashEngine = MessageDigest.getInstance("MD5");
                hashEngine.update(dataToHash.getBytes("iso-8859-1"), 0, dataToHash.length());
                this.mData = MD5Hash.convertByteArrayToHexString(hashEngine.digest());
            }
            catch (Exception e) {
                new Logger("MD5").e(e, "error in calculating MD5 sum ", new Object[0]);
            }
        }
    }

    @Nullable
    private static String convertByteArrayToHexString(@Nullable byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int byteIndex = 0; byteIndex < data.length; ++byteIndex) {
            int halfbyte = data[byteIndex] >>> 4 & 0xF;
            int twoHalfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buffer.append((char)(48 + halfbyte));
                } else {
                    buffer.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[byteIndex] & 0xF;
            } while (twoHalfs++ < 1);
        }
        return buffer.toString();
    }

    @Nullable
    public String getMd5Hash() {
        return this.mData;
    }
}

