/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.os.Build;

public class MathUtil {
    private MathUtil() {
    }

    public static boolean isPointInPlane(int planeLeft, int planeTop, int planeWidth, int planeHeight, int pointX, int pointY) {
        return pointX >= planeLeft && pointX <= planeLeft + planeWidth && pointY >= planeTop && pointY <= planeTop + planeHeight;
    }

    public static double euclideanDistance(float startX, float startY, float endX, float endY) {
        float xDistance = endX - startX;
        float yDistance = endY - startY;
        return Math.sqrt(xDistance * xDistance + yDistance * yDistance);
    }

    static int calculateArea(int width, int height) {
        return width * height;
    }

    public static int compareInts(int first, int second) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Integer.compare(second, first);
        }
        int x = second;
        int y = first;
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int safeLongToInt(long valueToConvert) {
        return (int)Math.max(Math.min(valueToConvert, Integer.MAX_VALUE), Integer.MIN_VALUE);
    }

    public static int safeFloatToInt(float valueToConvert) {
        float half = 0.5f;
        return (int)(valueToConvert + 0.5f);
    }
}

