/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;

public class ResourceUtils {
    public static final String NULL_STRING_ID = "null";
    public static final String EMPTY_STRING_ID = "";
    @IdRes
    private static final long NEGATIVE_FORMAT = 0xFFFFFFL;
    @IdRes
    private static final long ZERO_FORMAT = 0L;

    private ResourceUtils() {
    }

    @NonNull
    public static String getResourceEntryName(@NonNull View view, String defaultVal) {
        return ResourceUtils.getResourceEntryName(view.getContext(), view.getId(), defaultVal);
    }

    @NonNull
    public static String getResourceEntryName(@NonNull Context context, @IdRes int viewId, String defaultVal) {
        String descriptor = defaultVal;
        if ((long)viewId != 0xFFFFFFL && (long)viewId != 0L && viewId != -1) {
            try {
                descriptor = context.getResources().getResourceEntryName(viewId);
            }
            catch (Resources.NotFoundException | NullPointerException throwable) {
                // empty catch block
            }
        }
        return descriptor;
    }
}

