/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.ViewGroup;
import com.contentsquare.android.internal.DeviceInfo;
import com.contentsquare.android.internal.Session;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.network.NetworkTransaction;
import com.contentsquare.android.internal.screengraph.Screengraph;
import com.contentsquare.android.internal.screengraph.ScreenshotGenerator;
import com.contentsquare.android.internal.util.UriBuilder;
import com.contentsquare.android.internal.util.ViewUtil;
import org.json.JSONObject;

public class ScreenRecorder {
    private final Logger mLogger = new Logger("ScreenRecorder");
    @NonNull
    private final UriBuilder mUriBuilder;
    @NonNull
    private final DeviceInfo mDeviceInfo;
    @NonNull
    private final Session mSession;
    @NonNull
    private final ViewUtil mViewUtil;

    public ScreenRecorder(@NonNull DeviceInfo deviceInfo, @NonNull Session session, @NonNull UriBuilder uriBuilder, @NonNull ViewUtil viewUtil) {
        this.mDeviceInfo = deviceInfo;
        this.mSession = session;
        this.mUriBuilder = uriBuilder;
        this.mViewUtil = viewUtil;
    }

    public void capture(@Nullable ViewGroup root, @Nullable String url, int targetPathId) {
        if (root == null) {
            this.mLogger.w("Failed to capture screen, decorView is null", new Object[0]);
            return;
        }
        if (this.mSession.canTakeScreenShots()) {
            this.createAndSendScreengraph(root, url, targetPathId);
            this.createAndSendScreenshot(root, url, targetPathId);
        } else {
            this.mLogger.i("Skipping screen capture, disabled in config (either project or god).", new Object[0]);
        }
    }

    @VisibleForTesting
    void createAndSendScreengraph(@NonNull ViewGroup root, @Nullable String url, int targetPathId) {
        JSONObject screen = this.getScreengraph().obtain(root, url, targetPathId);
        String endpoint = this.mUriBuilder.buildScreengraphUrl(this.mSession.getGodModeConfig().getScreengraphUploadUrl(), this.mSession.getRunConfiguration().getCsProjectId(), this.mDeviceInfo.getDeviceIntType());
        this.sendJsonToServer(screen, endpoint);
    }

    @VisibleForTesting
    void createAndSendScreenshot(@NonNull ViewGroup root, @Nullable String url, int targetPathId) {
        JSONObject screenshotJson = this.getScreenshotGenerator().obtain(url, root, targetPathId);
        String endpoint = this.mUriBuilder.buildScreenshotUrl(this.mSession.getGodModeConfig().getScreengraphUploadUrl(), this.mSession.getRunConfiguration().getCsProjectId(), this.mDeviceInfo.getDeviceIntType());
        this.sendJsonToServer(screenshotJson, endpoint);
    }

    @VisibleForTesting
    Screengraph getScreengraph() {
        return new Screengraph();
    }

    @VisibleForTesting
    ScreenshotGenerator getScreenshotGenerator() {
        return new ScreenshotGenerator(this.mViewUtil);
    }

    @VisibleForTesting
    void sendJsonToServer(@Nullable JSONObject screen, final @NonNull String destination) {
        if (screen == null) {
            this.mLogger.d("Generated Screengraph is null, aborting...", new Object[0]);
            return;
        }
        NetworkTransaction.NetworkTransactionListener listener = new NetworkTransaction.NetworkTransactionListener(){

            @Override
            public void pass() {
                ScreenRecorder.this.mLogger.d("Successfully sent to %s", destination);
            }

            @Override
            public void fail() {
                ScreenRecorder.this.mLogger.d("Failed sending to %s", destination);
            }
        };
        NetworkTransaction nt = new NetworkTransaction();
        nt.scheduleSend(screen, destination, listener);
    }
}

