/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.contentsquare.android.internal.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Strings {
    static final String UTF_8 = "UTF-8";
    @NonNull
    private static final Logger LOGGER = new Logger("Strings");

    private Strings() {
    }

    @NonNull
    public static String nullToEmpty(@Nullable String string) {
        return string == null ? "" : string;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String encode(@Nullable String string) {
        if (Strings.isNullOrEmpty(string)) {
            return string;
        }
        try {
            return URLEncoder.encode(string, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.w(e, "Failed to encode sting to UTF, exception : ", new Object[0]);
            return null;
        }
    }
}

