/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.support.annotation.NonNull;
import com.contentsquare.android.internal.DeviceInfo;
import java.util.Locale;

public class UriBuilder {
    public static final String PROJECT_CONFIG_RELEASE_URL = "https://mobile-production.content-square.net/android/config/v1/";
    public static final String PROJECT_CONFIG_DEBUG_URL = "https://mobile-dev.content-square.net/android/config/v1/";
    public static final String PROJECT_GOD_MODE_CONFIG_URL = "https://s3-eu-west-1.amazonaws.com/cs-mobile-dev/android/god/cs-override.json";
    private static final String EXTENSION = ".json";
    private static final String EVENTS_VERSION = "v2";
    private static final String EVENTS_ENDPOINT = "events";
    private static final String SCREENGRAPH_VERSION = "v1";
    @NonNull
    private final DeviceInfo mDeviceInfo;

    public UriBuilder(@NonNull DeviceInfo deviceInfo) {
        this.mDeviceInfo = deviceInfo;
    }

    @NonNull
    public String buildProjectConfigUrl(@NonNull String projectId) {
        return this.buildConfigUrl(projectId, this.mDeviceInfo.isDebugBuild());
    }

    @NonNull
    public String buildProjectConfigUrlForDebug(@NonNull String projectId) {
        return this.buildConfigUrl(projectId, true);
    }

    @NonNull
    private String buildConfigUrl(String projectId, boolean isDebug) {
        return this.configEndpoint(isDebug) + projectId.toLowerCase(Locale.getDefault()) + EXTENSION;
    }

    @NonNull
    private String configEndpoint(boolean isDebug) {
        return isDebug ? PROJECT_CONFIG_DEBUG_URL : PROJECT_CONFIG_RELEASE_URL;
    }

    @NonNull
    public String godModeConfigEndpoint() {
        return PROJECT_GOD_MODE_CONFIG_URL;
    }

    @NonNull
    public String buildEventsUrl(@NonNull String servername) {
        return servername + "/mobile/" + EVENTS_VERSION + "/" + EVENTS_ENDPOINT;
    }

    @NonNull
    String buildScreengraphUrl(@NonNull String servername, int projectId, int deviceType) {
        return servername + "/screengraphs/" + SCREENGRAPH_VERSION + "/screengraph/project/" + projectId + "/device/" + deviceType;
    }

    @NonNull
    String buildScreenshotUrl(@NonNull String servername, int projectId, int deviceType) {
        return servername + "/screengraphs/" + SCREENGRAPH_VERSION + "/screenshot/project/" + projectId + "/device/" + deviceType;
    }
}

