/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.screengraph.JsonMetadataView;
import com.contentsquare.android.internal.screengraph.JsonView;
import com.contentsquare.android.internal.ui.processor.descriptors.PathDescriptor;
import com.contentsquare.android.internal.util.MathUtil;
import com.contentsquare.android.internal.util.ResourceUtils;
import com.contentsquare.android.internal.util.ViewUtil$AjcClosure1;
import hugo.weaving.DebugLog;
import hugo.weaving.internal.Hugo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ViewUtil {
    private static final String COLOR_TRANSPARENT = "#00FFFFFF";
    private static final int FAKE_VALUE = 0;
    private static final int COMPRESS_QUALITY = 100;
    private static final int COLOR_FORMAT = 0xFFFFFF;
    private final Logger mLogger = new Logger("ViewUtil");
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    private static boolean viewSupportsAdapter(View biggest) {
        return biggest instanceof AdapterView || biggest.getClass().toString().contains("RecyclerView");
    }

    public static int convertDpsToPixel(int dps, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float scale = (float)metrics.densityDpi / 160.0f;
        return MathUtil.safeFloatToInt((float)dps * scale);
    }

    public static int convertPixelsToDps(int px, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float scale = (float)metrics.densityDpi / 160.0f;
        return MathUtil.safeFloatToInt((float)px / scale);
    }

    @DebugLog
    @NonNull
    public View getBiggestViewInHierarchy(@NonNull ViewGroup root) {
        ViewGroup viewGroup = root;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)viewGroup);
        Object[] objectArray = new Object[]{this, viewGroup, joinPoint};
        return (View)Hugo.aspectOf().logAndExecute(new ViewUtil$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @NonNull
    public String encodeImage(@NonNull byte[] imageByteArray) {
        return Base64.encodeToString((byte[])imageByteArray, (int)0);
    }

    public JsonView toObject(@NonNull View view) {
        JsonView viewObj = new JsonView(this);
        int[] locationXy = new int[2];
        view.getLocationOnScreen(locationXy);
        PathDescriptor pathDecriptor = new PathDescriptor();
        JsonMetadataView metaObj = new JsonMetadataView();
        metaObj.setClassName(view.getClass().getSimpleName());
        metaObj.setFullPath(pathDecriptor.generateAnalyticsPath(view));
        metaObj.setChildOrder(0);
        viewObj.setHeight(view.getHeight());
        viewObj.setWidth(view.getWidth());
        viewObj.setPosX(locationXy[0]);
        viewObj.setPosY(locationXy[1]);
        viewObj.setVisible(view.getVisibility() == 0);
        viewObj.setMetadata(metaObj.toJson());
        if (view instanceof ViewGroup) {
            viewObj.setBackground(this.getBackgroundColor(view));
        } else {
            viewObj.setBitmap(this.toByteArray(view));
        }
        String descriptor = ResourceUtils.getResourceEntryName(view, "null");
        viewObj.setId(descriptor);
        return viewObj;
    }

    @NonNull
    public byte[] toByteArray(@NonNull View view) {
        if (view.getHeight() > 0 && view.getWidth() > 0) {
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            view.draw(canvas);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            return stream.toByteArray();
        }
        return new byte[0];
    }

    @NonNull
    public String getBackgroundColor(@NonNull View view) {
        Drawable background = view.getBackground();
        String backgroundColor = COLOR_TRANSPARENT;
        if (background instanceof ColorDrawable) {
            int color = ((ColorDrawable)background).getColor();
            backgroundColor = this.colorToHex(color);
        }
        return backgroundColor;
    }

    @NonNull
    public String colorToHex(int color) {
        return String.format("#%06X", 0xFFFFFF & color);
    }

    public void verifyViewDetached(@NonNull View view) {
        ViewGroup parent = (ViewGroup)view.getParent();
        if (parent != null) {
            parent.removeView(view);
        }
    }

    static {
        ViewUtil.ajc$preClinit();
    }

    static final /* synthetic */ View getBiggestViewInHierarchy_aroundBody0(ViewUtil ajc$this, ViewGroup root, JoinPoint joinPoint) {
        ArrayBlockingQueue<ViewGroup> queue = new ArrayBlockingQueue<ViewGroup>(1);
        PriorityQueue<Pair<View, Integer>> areas = new PriorityQueue<Pair<View, Integer>>(10, new Comparator<Pair<View, Integer>>(){

            @Override
            public int compare(Pair<View, Integer> one, Pair<View, Integer> two) {
                return MathUtil.compareInts((Integer)one.second, (Integer)two.second);
            }
        });
        queue.add(root);
        ajc$this.mLogger.d("Finding the biggest segment in %s", root.toString());
        while (!queue.isEmpty()) {
            areas.clear();
            ViewGroup element = (ViewGroup)queue.poll();
            int childCount = element.getChildCount();
            if (childCount == 0) {
                ajc$this.mLogger.d("View Group without children detected, returning", element.toString());
                return element;
            }
            for (int i = 0; i < childCount; ++i) {
                View child = element.getChildAt(i);
                if (child == null || child.getVisibility() != 0) {
                    ajc$this.mLogger.e("Child  was null or invisible, skipping, %s", child);
                    continue;
                }
                int area = MathUtil.calculateArea(child.getWidth(), child.getHeight());
                areas.add((Pair<View, Integer>)new Pair((Object)child, (Object)area));
            }
            if (areas.isEmpty()) {
                return element;
            }
            View biggest = (View)areas.poll().first;
            if (ViewUtil.viewSupportsAdapter(biggest)) {
                return biggest;
            }
            if (biggest instanceof ViewGroup) {
                ajc$this.mLogger.d("adding child for processing : %s", biggest);
                queue.add((ViewGroup)biggest);
                continue;
            }
            View result = (View)biggest.getParent();
            ajc$this.mLogger.d("found biggest child, returning it's parent : %s", result);
            return result;
        }
        ajc$this.mLogger.e("we have an error in processing, returning the root view.", new Object[0]);
        return root;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ViewUtil.java", ViewUtil.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBiggestViewInHierarchy", "com.contentsquare.android.internal.util.ViewUtil", "android.view.ViewGroup", "root", "", "android.view.View"), 93);
    }
}

