/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.validator;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.util.Strings;

public class GodModeClipboardValidator {
    private final Logger mLogger = new Logger(GodModeClipboardValidator.class.getSimpleName());
    @NonNull
    private final Context mContext;
    @Nullable
    private String mCurrentClipboardKey;

    @UiThread
    public GodModeClipboardValidator(@NonNull Context context) {
        this.mContext = context;
    }

    public void fetchClipboardData() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mCurrentClipboardKey = null;
            ClipboardManager clipboard = (ClipboardManager)this.mContext.getSystemService("clipboard");
            if (clipboard == null) {
                return;
            }
            ClipData clipData = clipboard.getPrimaryClip();
            if (clipData == null) {
                return;
            }
            ClipData.Item item = clipData.getItemAt(0);
            if (item == null) {
                return;
            }
            CharSequence itemText = item.getText();
            if (itemText == null) {
                return;
            }
            this.mCurrentClipboardKey = itemText.toString();
        } else {
            this.mLogger.e("Failed to fetch Clip. Call was made outside of the main thread.", new Object[0]);
            this.mCurrentClipboardKey = null;
        }
    }

    public boolean isGodModeKeyVerified(@Nullable String godModeKey) {
        if (Strings.isNullOrEmpty(godModeKey)) {
            return false;
        }
        boolean isGodModeValid = godModeKey.equals(this.mCurrentClipboardKey);
        this.mLogger.i("Godmode validation %s", isGodModeValid ? "passed." : "did not pass.");
        return isGodModeValid;
    }
}

