/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.internal.validator;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.contentsquare.android.internal.logging.Logger;
import com.contentsquare.android.internal.preferences.PrefsHelper;
import com.contentsquare.android.internal.util.RandomGenerator;

public class InSampleIntervalValidator {
    public static final String TAG = "InSampleIntervalValidator";
    @NonNull
    private final PrefsHelper mPrefsHelper;
    @NonNull
    private final Logger mLogger;

    public InSampleIntervalValidator(@NonNull PrefsHelper prefsHelper, @NonNull Logger logger) {
        this.mPrefsHelper = prefsHelper;
        this.mLogger = logger;
    }

    public boolean isInSampleInterval(float sampleRate) {
        int segmentSize = this.computeSegmentSize(sampleRate);
        this.updateAudienceRestrictionsIfNeeded(this.mPrefsHelper, segmentSize);
        boolean isInAudience = this.mPrefsHelper.getBoolean("trackable", true);
        this.mLogger.d("segment=%d, inAudience = %b", segmentSize, isInAudience);
        return isInAudience;
    }

    private void updateAudienceRestrictionsIfNeeded(PrefsHelper preferences, int segmentSize) {
        int lastSegment = preferences.getInt("last_segment", -1);
        if (lastSegment != segmentSize) {
            int sample = this.getRandomAllocation();
            preferences.putInt("last_segment", segmentSize);
            preferences.putBoolean("trackable", sample < segmentSize);
        }
    }

    private int computeSegmentSize(float sampleRate) {
        int completeAudience = 100;
        return (int)(sampleRate * 100.0f);
    }

    @VisibleForTesting
    private int getRandomAllocation() {
        return RandomGenerator.getRandomAudiencePercentage();
    }
}

