/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.sdk;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.Pair;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import com.contentsquare.android.sdk.bl;
import com.contentsquare.android.sdk.cj;
import com.contentsquare.android.sdk.ck;
import com.contentsquare.android.sdk.dn;
import com.contentsquare.android.sdk.dp;
import com.contentsquare.android.sdk.ee;
import com.contentsquare.android.sdk.eh;
import com.contentsquare.android.sdk.f;
import hugo.weaving.DebugLog;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;

public class em {
    private final bl a = new bl("ViewUtil");

    public static int a(int n2, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        float f2 = (float)displayMetrics.densityDpi / 160.0f;
        return ee.a((float)n2 / f2);
    }

    @Nullable
    @CheckResult
    public static <T> T a(@NonNull Class<T> clazz, @NonNull ViewGroup viewGroup) {
        if (clazz.isAssignableFrom(viewGroup.getClass())) {
            return (T)viewGroup;
        }
        LinkedList<ViewGroup> linkedList = new LinkedList<ViewGroup>();
        linkedList.add(viewGroup);
        while (!linkedList.isEmpty()) {
            ViewGroup viewGroup2 = (ViewGroup)linkedList.remove();
            for (int i2 = 0; i2 < viewGroup2.getChildCount(); ++i2) {
                View view = viewGroup2.getChildAt(i2);
                if (clazz.isAssignableFrom(view.getClass())) {
                    return (T)view;
                }
                if (!(view instanceof ViewGroup)) continue;
                linkedList.add((ViewGroup)view);
            }
        }
        return null;
    }

    @NonNull
    @CheckResult
    public Bitmap a(@NonNull View view) {
        boolean bl2 = view.isDrawingCacheEnabled();
        boolean bl3 = view.willNotCacheDrawing();
        boolean bl4 = view.willNotDraw();
        view.setDrawingCacheEnabled(true);
        view.setWillNotCacheDrawing(false);
        view.setWillNotDraw(false);
        view.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        Bitmap bitmap2 = bitmap == null ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : bitmap.copy(Bitmap.Config.ARGB_8888, false);
        view.setDrawingCacheEnabled(bl2);
        view.setWillNotCacheDrawing(bl3);
        view.setWillNotDraw(bl4);
        return bitmap2;
    }

    @DebugLog
    @NonNull
    public View a(@NonNull ViewGroup viewGroup) {
        try {
            ArrayBlockingQueue<ViewGroup> arrayBlockingQueue = new ArrayBlockingQueue<ViewGroup>(1);
            arrayBlockingQueue.add(viewGroup);
            this.a.a("Finding the biggest segment in %s", viewGroup.toString());
            while (!arrayBlockingQueue.isEmpty()) {
                ViewGroup viewGroup2 = (ViewGroup)arrayBlockingQueue.poll();
                View view = this.b(viewGroup2);
                if (view == null) {
                    return viewGroup2;
                }
                if (view instanceof AdapterView || view.getClass().toString().contains("RecyclerView")) {
                    this.a.a("Found a RecyclerView, returning as biggest: %s", view);
                    return view;
                }
                if (view instanceof ViewGroup) {
                    this.a.a("Adding child for processing: %s", view);
                    arrayBlockingQueue.add((ViewGroup)view);
                    continue;
                }
                View view2 = this.b(view);
                this.a.a("Found biggest child, returning: %s", view2);
                return view2;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.a.d("We got a NullPointerException error, returning the root view - %s", nullPointerException);
        }
        this.a.d("We have an error in processing, returning the root view.", new Object[0]);
        return viewGroup;
    }

    @Nullable
    public View b(@NonNull ViewGroup viewGroup) {
        try {
            PriorityQueue<Pair<View, Integer>> priorityQueue = new PriorityQueue<Pair<View, Integer>>(10, new Comparator<Pair<View, Integer>>(){

                public int a(Pair<View, Integer> pair, Pair<View, Integer> pair2) {
                    return ee.b((Integer)pair.second, (Integer)pair2.second);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((Pair<View, Integer>)((Pair)object), (Pair<View, Integer>)((Pair)object2));
                }
            });
            int n2 = viewGroup.getChildCount();
            if (n2 == 0) {
                this.a.a("View Group without children detected, returning", viewGroup.toString());
                return null;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                View view = viewGroup.getChildAt(i2);
                if (view == null || view.getVisibility() != 0) {
                    this.a.d("Child was null or invisible, skipping, %s", view);
                    continue;
                }
                int n3 = ee.a(view.getWidth(), view.getHeight());
                priorityQueue.add((Pair<View, Integer>)new Pair((Object)view, (Object)n3));
            }
            if (priorityQueue.isEmpty()) {
                return null;
            }
            return (View)priorityQueue.poll().first;
        }
        catch (NullPointerException nullPointerException) {
            this.a.d("We got a NullPointerException error, returning the root view - %s", nullPointerException);
            return null;
        }
    }

    @NonNull
    public View b(@NonNull View view) {
        ViewParent viewParent = view.getParent();
        View view2 = viewParent instanceof View ? (View)viewParent : view;
        return view2;
    }

    @NonNull
    public String a(@NonNull byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)0);
    }

    public ck c(@NonNull View view) {
        ck ck2 = new ck(this);
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        dp dp2 = new dp();
        cj cj2 = new cj();
        cj2.a(view.getClass().getSimpleName());
        cj2.b(dp2.a(view));
        cj2.a(0);
        ck2.b(view.getHeight());
        ck2.a(view.getWidth());
        ck2.c(nArray[0]);
        ck2.d(nArray[1]);
        ck2.a(view.getVisibility() == 0);
        ck2.a(cj2.d());
        if (view instanceof ViewGroup) {
            ck2.b(this.f(view));
            ck2.a(this.e(view));
        } else {
            ck2.a(this.d(view));
        }
        String string = eh.a(view, "null");
        ck2.a(string);
        return ck2;
    }

    @NonNull
    public byte[] d(@NonNull View view) {
        if (view.getHeight() > 0 && view.getWidth() > 0) {
            Bitmap bitmap = this.a(view);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    @VisibleForTesting
    float e(@NonNull View view) {
        Drawable drawable = view.getBackground();
        float f2 = 1.0f;
        if (view instanceof ViewGroup && drawable instanceof ColorDrawable) {
            f2 = view.getAlpha();
        }
        return f2;
    }

    @VisibleForTesting
    @NonNull
    String f(@NonNull View view) {
        Drawable drawable = view.getBackground();
        String string = "#00FFFFFF";
        if (drawable instanceof ColorDrawable) {
            int n2 = ((ColorDrawable)drawable).getColor();
            string = this.a(n2);
        }
        return string;
    }

    @VisibleForTesting
    @NonNull
    String a(int n2) {
        return String.format("#%08X", n2);
    }

    @NonNull
    public f<View> a(@NonNull ViewGroup viewGroup, final int n2, final int n3) {
        final f<View> f2 = new f<View>();
        dn.a(new dn.a(){

            @Override
            public void a(@NonNull View view) {
                if (this.c(view) && this.b(view) && this.d(view)) {
                    f2.a(view);
                }
            }

            @Override
            public void a(@NonNull ViewGroup viewGroup) {
                if (this.c((View)viewGroup) && this.b((View)viewGroup) && this.d((View)viewGroup)) {
                    f2.a(viewGroup);
                }
            }

            private boolean b(@NonNull View view) {
                int[] nArray = new int[2];
                view.getLocationOnScreen(nArray);
                int n22 = view.getWidth();
                int n32 = view.getHeight();
                return ee.a(nArray[0], nArray[1], n22, n32, n2, n3);
            }

            private boolean c(View view) {
                String string = eh.a(view, "");
                return !string.contains("cs_glass_pane");
            }

            private boolean d(View view) {
                return view.getVisibility() == 0;
            }
        }).a(viewGroup);
        return f2;
    }

    public static void g(@NonNull View view) {
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        if (viewGroup != null) {
            viewGroup.removeView(view);
        }
    }

    public static void a(@NonNull ViewGroup viewGroup, @NonNull ViewGroup viewGroup2) {
        int n2 = viewGroup.getChildCount();
        if (n2 == 0) {
            return;
        }
        LinkedList<View> linkedList = new LinkedList<View>();
        for (int i2 = 0; i2 < n2; ++i2) {
            View view = viewGroup.getChildAt(i2);
            if (view == null) continue;
            linkedList.add(view);
        }
        while (!linkedList.isEmpty()) {
            View view = (View)linkedList.poll();
            viewGroup.removeView(view);
            viewGroup2.addView(view);
        }
    }
}

