/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.api.bridge.flutter;

import android.graphics.Color;
import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.api.bridge.flutter.FlutterMutation;
import com.contentsquare.android.api.bridge.flutter.HtmlObject;
import com.contentsquare.android.api.bridge.flutter.MetadataObject;
import com.contentsquare.android.api.bridge.flutter.ShadowObject;
import com.contentsquare.android.api.bridge.flutter.StyleObject;
import com.contentsquare.android.api.bridge.flutter.TextInfoObject;
import com.contentsquare.android.common.sessionreplay.ViewLight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0007J\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\"\u001a\u00020\bH\u0002J\u0014\u0010#\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010$\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0014\u0010%\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/contentsquare/android/api/bridge/flutter/FlutterMutationToViewLightConverter;", "", "pixelRatio", "", "(F)V", "createViewLightFromFlutter", "Lcom/contentsquare/android/common/sessionreplay/ViewLight;", "flutterMutation", "Lcom/contentsquare/android/api/bridge/flutter/FlutterMutation;", "handleHtmlString", "", "htmlString", "rgbToHex", "rgb", "createChildrenFrom", "", "childrenObject", "", "createHtmlFrom", "html", "Lcom/contentsquare/android/api/bridge/flutter/HtmlObject;", "createMetadataFrom", "metadata", "Lcom/contentsquare/android/api/bridge/flutter/MetadataObject;", "createShadowFrom", "shadow", "Lcom/contentsquare/android/api/bridge/flutter/ShadowObject;", "createStyleFrom", "style", "Lcom/contentsquare/android/api/bridge/flutter/StyleObject;", "createTextInfosFrom", "textInfo", "Lcom/contentsquare/android/api/bridge/flutter/TextInfoObject;", "createViewFrom", "mutation", "handleAdvancedStyle", "handleBackgroundVisuals", "handleBasicCoordinates", "Companion", "library_release"})
public final class FlutterMutationToViewLightConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int HEXADECIMAL_BASE = 16;
    @NotNull
    private static final String HTML_PX_REGEX = "\\d+\\.?\\d*px";
    @NotNull
    private static final String RGB_VALUE = "(?:[01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])";
    @NotNull
    private static final String RGB_FORMAT_REGEX = "rgb\\((?:[01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])\\s*,\\s*(?:[01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])\\s*,\\s*(?:[01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])\\)";
    @NotNull
    public static final String WRONG_FORMAT_ERROR_MESSAGE = "is not in the correct format";
    private final float pixelRatio;

    public FlutterMutationToViewLightConverter(float f10) {
        this.pixelRatio = f10;
    }

    private final void createViewFrom(ViewLight viewLight, FlutterMutation flutterMutation) {
        if (flutterMutation.getRecordingId() != null) {
            viewLight.setRecordingId(flutterMutation.getRecordingId().intValue());
        }
        if (flutterMutation.getMetadata() != null) {
            this.createMetadataFrom(viewLight, flutterMutation.getMetadata());
        }
        if (flutterMutation.getStyle() != null) {
            this.createStyleFrom(viewLight, flutterMutation.getStyle());
        }
        if (flutterMutation.getChildren() != null) {
            this.createChildrenFrom(viewLight, flutterMutation.getChildren());
        }
    }

    private final void createChildrenFrom(ViewLight viewLight, List<FlutterMutation> list) {
        int n10 = list.size();
        for (int i10 = 0; i10 < n10; ++i10) {
            ViewLight viewLight2 = this.createViewLightFromFlutter(list.get(i10));
            viewLight2.setParentId(viewLight.getRecordingId());
            viewLight2.setIndexInParent(i10);
            viewLight.getChildren().add(viewLight2);
        }
    }

    private final void createMetadataFrom(ViewLight viewLight, MetadataObject metadataObject) {
        viewLight.setMetadataClassName(metadataObject.getClassName());
        viewLight.setMetadataFullPath(metadataObject.getIncrementalPath());
    }

    private final void createStyleFrom(ViewLight viewLight, StyleObject object) {
        FlutterMutationToViewLightConverter flutterMutationToViewLightConverter = this;
        flutterMutationToViewLightConverter.handleBasicCoordinates(viewLight, (StyleObject)object);
        flutterMutationToViewLightConverter.handleBackgroundVisuals(viewLight, (StyleObject)object);
        flutterMutationToViewLightConverter.handleAdvancedStyle(viewLight, (StyleObject)object);
        Object object2 = ((StyleObject)object).getHtml();
        if (object2 != null) {
            this.createHtmlFrom(viewLight, (HtmlObject)object2);
        }
        if ((object2 = ((StyleObject)object).getShadow()) != null) {
            this.createShadowFrom(viewLight, (ShadowObject)object2);
        }
        if ((object = ((StyleObject)object).getTextInfos()) != null) {
            this.createTextInfosFrom(viewLight, (TextInfoObject)object);
        }
    }

    private final void handleAdvancedStyle(ViewLight viewLight, StyleObject object) {
        Number number = ((StyleObject)object).getAlpha();
        number = number != null ? Float.valueOf((float)number.doubleValue()) : null;
        viewLight.setViewAlpha((Float)number);
        viewLight.setVisible(((StyleObject)object).getVisibility());
        viewLight.setClipChildren(((StyleObject)object).getClipChildren());
        viewLight.setBlur(((StyleObject)object).getBlur());
        object = ((StyleObject)object).getCornerRadius();
        Float f10 = object != null ? Float.valueOf((float)((Double)object * (double)((FlutterMutationToViewLightConverter)((Object)f10)).pixelRatio)) : null;
        viewLight.setCornerRadius(f10);
    }

    private final void handleBasicCoordinates(ViewLight viewLight, StyleObject object) {
        Number number = ((StyleObject)object).getX();
        number = number != null ? Integer.valueOf((int)((Double)number * (double)((FlutterMutationToViewLightConverter)((Object)n10)).pixelRatio)) : null;
        viewLight.setPosX((Integer)number);
        number = ((StyleObject)object).getY();
        number = number != null ? Integer.valueOf((int)((Double)number * (double)((FlutterMutationToViewLightConverter)((Object)n10)).pixelRatio)) : null;
        viewLight.setPosY((Integer)number);
        number = ((StyleObject)object).getWidth();
        number = number != null ? Integer.valueOf((int)((Double)number * (double)((FlutterMutationToViewLightConverter)((Object)n10)).pixelRatio)) : null;
        viewLight.setWidth((Integer)number);
        object = ((StyleObject)object).getHeight();
        Integer n10 = object != null ? Integer.valueOf((int)((Double)object * (double)((FlutterMutationToViewLightConverter)((Object)n10)).pixelRatio)) : null;
        viewLight.setHeight(n10);
    }

    private final void createHtmlFrom(ViewLight viewLight, HtmlObject htmlObject) {
        String string = htmlObject.getContent();
        String string2 = string != null ? ((FlutterMutationToViewLightConverter)((Object)string2)).handleHtmlString(string) : null;
        viewLight.setHtmlContent(string2);
        viewLight.setHtmlLines(htmlObject.getLines());
    }

    private final void createShadowFrom(ViewLight viewLight, ShadowObject shadowObject) {
        Double d10 = shadowObject.getRadius();
        double d11 = d10 != null ? d10 : 0.0;
        viewLight.setShadowRadius((float)(d11 * (double)((FlutterMutationToViewLightConverter)((Object)d16)).pixelRatio));
        Double d12 = shadowObject.getOffsetX();
        double d13 = d12 != null ? d12 : 0.0;
        viewLight.setShadowOffsetX((float)(d13 * (double)((FlutterMutationToViewLightConverter)((Object)d16)).pixelRatio));
        Double d14 = shadowObject.getOffsetY();
        double d15 = d14 != null ? d14 : 0.0;
        viewLight.setShadowOffsetY((float)(d15 * (double)((FlutterMutationToViewLightConverter)((Object)d16)).pixelRatio));
        Double d16 = shadowObject.getOpacity();
        float f10 = d16 != null ? (float)d16.doubleValue() : 0.0f;
        viewLight.setShadowOpacity(f10);
    }

    private final void createTextInfosFrom(ViewLight viewLight, TextInfoObject textInfoObject) {
        Double d10 = textInfoObject.getSize();
        double d11 = d10 != null ? d10 : 0.0;
        viewLight.setTextInfosSize(d11 * (double)((FlutterMutationToViewLightConverter)((Object)string2)).pixelRatio);
        String string = textInfoObject.getColor();
        String string2 = string != null ? ((FlutterMutationToViewLightConverter)((Object)string2)).rgbToHex(string) : null;
        viewLight.setTextInfosColor(string2);
        viewLight.setTextInfosAlignment(textInfoObject.getAlignment());
        viewLight.setTextInfosFont(textInfoObject.getFont());
        viewLight.setTextInfosLines(textInfoObject.getLines());
        viewLight.setTextInfosText(textInfoObject.getText());
        viewLight.setTextInfosFamilyName(textInfoObject.getFamilyName());
    }

    public static final /* synthetic */ float access$getPixelRatio$p(FlutterMutationToViewLightConverter flutterMutationToViewLightConverter) {
        return flutterMutationToViewLightConverter.pixelRatio;
    }

    @NotNull
    public final ViewLight createViewLightFromFlutter(@NotNull FlutterMutation flutterMutation) {
        FlutterMutation flutterMutation2 = flutterMutation;
        Intrinsics.checkNotNullParameter((Object)flutterMutation2, (String)"flutterMutation");
        ViewLight viewLight = ViewLight.Companion.obtainForFlutter();
        if (flutterMutation2.getView() == null && flutterMutation.getStyle() == null) {
            StyleObject styleObject = flutterMutation.getStyleChanges();
            if (styleObject != null) {
                ((FlutterMutationToViewLightConverter)this).createStyleFrom(viewLight, styleObject);
            }
            if ((this = flutterMutation.getRecordingId()) != null) {
                viewLight.setRecordingId(((Number)this).intValue());
            }
        } else {
            ((FlutterMutationToViewLightConverter)this).createViewFrom(viewLight, flutterMutation);
        }
        return viewLight;
    }

    @VisibleForTesting
    public final void handleBackgroundVisuals(@NotNull ViewLight viewLight, @NotNull StyleObject styleObject) {
        block7: {
            block6: {
                byte[] byArray;
                StyleObject styleObject2 = styleObject;
                Intrinsics.checkNotNullParameter((Object)viewLight, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)styleObject2, (String)"style");
                if (styleObject2.getBmp() == null || !(styleObject.getBmp().length() > 0)) break block6;
                ViewLight viewLight2 = viewLight;
                try {
                    viewLight2.setEncodedBitmap(Base64.decode((String)styleObject.getBmp(), (int)0));
                    byArray = viewLight2.getEncodedBitmap();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("The bmp string is not in the correct format", illegalArgumentException);
                }
                Object object = byArray;
                if (byArray == null) break block7;
                viewLight.setViewBitmapHash(String.valueOf(Arrays.hashCode((byte[])object)));
            }
            if (styleObject.getPlaceholder() != null) {
                viewLight.setPlaceHolder(styleObject.getPlaceholder());
            } else if (styleObject.getBg() != null) {
                viewLight.setBackgroundColor(Color.parseColor((String)styleObject.getBg()));
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public final String rgbToHex(@NotNull String object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"rgb");
        if (new Regex(RGB_FORMAT_REGEX).containsMatchIn((CharSequence)object)) {
            ArrayList arrayList;
            Iterator iterator = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)object, (CharSequence)"rgb("), (CharSequence)")"), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            object = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((String)iterator.next()))).toString()));
            }
            Object object2 = object;
            int n10 = ((Number)object2.get(1)).intValue();
            int n11 = ((Number)object2.get(2)).intValue();
            String string = Integer.toString(((Number)object.get(0)).intValue(), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string2 = StringsKt.padStart((String)string, (int)2, (char)'0');
            String string3 = Integer.toString(n10, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
            String string4 = StringsKt.padStart((String)string3, (int)2, (char)'0');
            String string5 = Integer.toString(n11, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
            return "#FF" + string2 + string4 + StringsKt.padStart((String)string5, (int)2, (char)'0');
        }
        throw new IllegalArgumentException("The rgb string is not in the correct format");
    }

    @VisibleForTesting
    @NotNull
    public final String handleHtmlString(@NotNull String string) {
        Function1<MatchResult, CharSequence> function1;
        Intrinsics.checkNotNullParameter((Object)string, (String)"htmlString");
        string = function1;
        function1 = new Function1<MatchResult, CharSequence>(this){
            final /* synthetic */ FlutterMutationToViewLightConverter this$0;
            {
                this.this$0 = flutterMutationToViewLightConverter;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult matchResult) {
                MatchResult matchResult2 = matchResult;
                Intrinsics.checkNotNullParameter((Object)matchResult2, (String)"it");
                float f10 = Float.parseFloat(StringsKt.removeSuffix((String)matchResult2.getValue(), (CharSequence)"px"));
                return FlutterMutationToViewLightConverter.access$getPixelRatio$p(this.this$0) * f10 + "px";
            }
        };
        return new Regex(HTML_PX_REGEX).replace((CharSequence)string, (Function1)string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u000b"}, d2={"Lcom/contentsquare/android/api/bridge/flutter/FlutterMutationToViewLightConverter$Companion;", "", "()V", "HEXADECIMAL_BASE", "", "HTML_PX_REGEX", "", "RGB_FORMAT_REGEX", "RGB_VALUE", "WRONG_FORMAT_ERROR_MESSAGE", "getWRONG_FORMAT_ERROR_MESSAGE$annotations", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getWRONG_FORMAT_ERROR_MESSAGE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

