/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.api.bridge.xpf;

import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.api.bridge.xpf.ExternalBridgeInterface;
import com.contentsquare.android.common.communication.ErrorAnalysisInterface;
import com.contentsquare.android.common.features.preferences.PreferencesKey;
import com.contentsquare.android.common.features.preferences.PreferencesStore;
import com.contentsquare.android.sdk.d7;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\nR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/contentsquare/android/api/bridge/xpf/BridgeManager;", "", "preferencesStore", "Lcom/contentsquare/android/common/features/preferences/PreferencesStore;", "(Lcom/contentsquare/android/common/features/preferences/PreferencesStore;)V", "isApiErrorEnabled", "", "Ljava/lang/Boolean;", "registeredExternalBridges", "", "Lcom/contentsquare/android/api/bridge/xpf/ExternalBridgeInterface;", "getRegisteredExternalBridges$annotations", "()V", "getRegisteredExternalBridges", "()Ljava/util/List;", "enableApiErrorForRegisteredBridges", "", "enable", "getCurrentApiErrorEnabledState", "handleConfiguration", "registerExternalBridge", "externalBridge", "setIsApiErrorEnabledIfNeeded", "unregisterExternalBridge", "library_release"})
public final class BridgeManager {
    @NotNull
    private final List<ExternalBridgeInterface> registeredExternalBridges;
    @Nullable
    private Boolean isApiErrorEnabled;

    public BridgeManager(@NotNull PreferencesStore preferencesStore) {
        BridgeManager bridgeManager = this;
        Intrinsics.checkNotNullParameter((Object)preferencesStore, (String)"preferencesStore");
        preferencesStore.registerOnChangedListener(arg_0 -> BridgeManager._init_$lambda$0(bridgeManager, arg_0));
        this.registeredExternalBridges = new ArrayList<ExternalBridgeInterface>();
    }

    @VisibleForTesting
    public static /* synthetic */ void getRegisteredExternalBridges$annotations() {
    }

    private final void handleConfiguration() {
        boolean bl = this.getCurrentApiErrorEnabledState();
        if (Intrinsics.areEqual((Object)this.isApiErrorEnabled, (Object)bl)) {
            return;
        }
        this.enableApiErrorForRegisteredBridges(bl);
    }

    private final void enableApiErrorForRegisteredBridges(boolean bl) {
        Iterator<ExternalBridgeInterface> iterator = ((BridgeManager)((Object)iterator)).registeredExternalBridges.iterator();
        while (iterator.hasNext()) {
            ((ExternalBridgeInterface)iterator.next()).enableApiErrors(bl);
        }
    }

    private final void setIsApiErrorEnabledIfNeeded() {
        if (this.isApiErrorEnabled != null) {
            return;
        }
        this.isApiErrorEnabled = this.getCurrentApiErrorEnabledState();
    }

    private final boolean getCurrentApiErrorEnabledState() {
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        for (Object e10 : d7.b) {
            if (!(e10 instanceof ErrorAnalysisInterface)) continue;
            ((ArrayList)object).add(e10);
        }
        return (object = (ErrorAnalysisInterface)CollectionsKt.firstOrNull((List)object)) != null ? object.isApiErrorEnabled() : false;
    }

    private static final void _init_$lambda$0(BridgeManager bridgeManager, String string) {
        Intrinsics.checkNotNullParameter((Object)bridgeManager, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)string, (String)"key");
        if (PreferencesKey.RAW_CONFIGURATION_AS_JSON.isEqualTo(string)) {
            bridgeManager.handleConfiguration();
        }
    }

    @NotNull
    public final List<ExternalBridgeInterface> getRegisteredExternalBridges() {
        return this.registeredExternalBridges;
    }

    public final void registerExternalBridge(@NotNull ExternalBridgeInterface externalBridgeInterface) {
        Intrinsics.checkNotNullParameter((Object)externalBridgeInterface, (String)"externalBridge");
        if (this.registeredExternalBridges.contains(externalBridgeInterface)) {
            return;
        }
        BridgeManager bridgeManager = this;
        bridgeManager.registeredExternalBridges.add(externalBridgeInterface);
        bridgeManager.setIsApiErrorEnabledIfNeeded();
        if (Intrinsics.areEqual((Object)bridgeManager.isApiErrorEnabled, (Object)Boolean.TRUE)) {
            externalBridgeInterface.enableApiErrors(true);
        }
    }

    public final void unregisterExternalBridge(@NotNull ExternalBridgeInterface externalBridgeInterface) {
        Intrinsics.checkNotNullParameter((Object)externalBridgeInterface, (String)"externalBridge");
        this.registeredExternalBridges.remove(externalBridgeInterface);
    }
}

